/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.EntryChange;
import org.apache.directory.api.ldap.model.name.Dn;

public class EntryChangeImpl
extends AbstractControl
implements EntryChange {
    private ChangeType changeType = ChangeType.ADD;
    private long changeNumber = -1L;
    private Dn previousDn = null;

    public EntryChangeImpl() {
        super("2.16.840.1.113730.3.4.7");
    }

    @Override
    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    @Override
    public Dn getPreviousDn() {
        return this.previousDn;
    }

    @Override
    public void setPreviousDn(Dn previousDn) {
        this.previousDn = previousDn;
    }

    @Override
    public long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 37 + (int)this.changeNumber;
        h = h * 37 + (this.changeType == null ? 0 : this.changeType.hashCode());
        h = h * 37 + (this.previousDn == null ? 0 : this.previousDn.hashCode());
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntryChange)) {
            return false;
        }
        EntryChange otherControl = (EntryChange)o;
        return super.equals(o) && this.changeNumber == otherControl.getChangeNumber() && this.changeType == otherControl.getChangeType() && this.previousDn.equals(otherControl.getPreviousDn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Entry Change Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        changeType   : '").append((Object)this.changeType).append("'\n");
        sb.append("        previousDN   : '").append(this.previousDn).append("'\n");
        if (this.changeNumber == -1L) {
            sb.append("        changeNumber : '").append("UNDEFINED").append("'\n");
        } else {
            sb.append("        changeNumber : '").append(this.changeNumber).append("'\n");
        }
        return sb.toString();
    }
}

