/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.ldapservers.LdapServersManagerIO;
import org.apache.directory.studio.ldapservers.LdapServersManagerIOException;
import org.apache.directory.studio.ldapservers.LdapServersManagerListener;
import org.apache.directory.studio.ldapservers.LdapServersPlugin;
import org.apache.directory.studio.ldapservers.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class LdapServersManager {
    private static final String SERVERS = "servers";
    private static LdapServersManager instance;
    private List<LdapServer> serversList;
    private Map<String, LdapServer> serversIdMap;
    private List<LdapServersManagerListener> listeners;

    private LdapServersManager() {
    }

    public static LdapServersManager getDefault() {
        if (instance == null) {
            instance = new LdapServersManager();
        }
        return instance;
    }

    public void addServer(LdapServer server) {
        this.addServer(server, true);
        this.saveServersToStore();
    }

    private void addServer(LdapServer server, boolean notifyListeners) {
        if (!this.serversList.contains(server)) {
            this.serversList.add(server);
            this.serversIdMap.put(server.getId(), server);
            if (notifyListeners) {
                LdapServersManagerListener[] ldapServersManagerListenerArray = this.listeners.toArray(new LdapServersManagerListener[0]);
                int n = ldapServersManagerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LdapServersManagerListener listener = ldapServersManagerListenerArray[n2];
                    listener.serverAdded(server);
                    ++n2;
                }
            }
        }
    }

    public void removeServer(LdapServer server) {
        this.removeServer(server, true);
        this.saveServersToStore();
    }

    private void removeServer(LdapServer server, boolean notifyListeners) {
        if (this.serversList.contains(server)) {
            this.serversList.remove(server);
            this.serversIdMap.remove(server.getId());
            if (notifyListeners) {
                LdapServersManagerListener[] ldapServersManagerListenerArray = this.listeners.toArray(new LdapServersManagerListener[0]);
                int n = ldapServersManagerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LdapServersManagerListener listener = ldapServersManagerListenerArray[n2];
                    listener.serverRemoved(server);
                    ++n2;
                }
            }
        }
    }

    public boolean containsServer(LdapServer server) {
        return this.serversList.contains(server);
    }

    public void addListener(LdapServersManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(LdapServersManagerListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void loadServersFromStore() {
        this.serversList = new ArrayList<LdapServer>();
        this.serversIdMap = new HashMap<String, LdapServer>();
        this.listeners = new ArrayList<LdapServersManagerListener>();
        File store = this.getServersStorePath().toFile();
        File tempStore = this.getServersStoreTempPath().toFile();
        boolean loadFailed = false;
        String exceptionMessage = "";
        if (store.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(store);
                List<LdapServer> servers = LdapServersManagerIO.read(inputStream);
                for (LdapServer server : servers) {
                    this.addServer(server, false);
                }
                return;
            }
            catch (FileNotFoundException e) {
                loadFailed = true;
                exceptionMessage = e.getMessage();
            }
            catch (LdapServersManagerIOException e) {
                loadFailed = true;
                exceptionMessage = e.getMessage();
            }
            if (loadFailed) {
                if (tempStore.exists()) {
                    try {
                        FileInputStream inputStream = new FileInputStream(tempStore);
                        List<LdapServer> servers = LdapServersManagerIO.read(inputStream);
                        for (LdapServer server : servers) {
                            this.addServer(server, false);
                        }
                        return;
                    }
                    catch (Exception e) {
                        CommonUIUtils.openErrorDialog((String)(String.valueOf(Messages.getString("LdapServersManager.ErrorLoadingServer")) + e.getMessage()));
                    }
                } else {
                    CommonUIUtils.openErrorDialog((String)(String.valueOf(Messages.getString("LdapServersManager.ErrorLoadingServer")) + exceptionMessage));
                }
            }
        }
    }

    public void saveServersToStore() {
        FileOutputStream outputStream;
        File store = this.getServersStorePath().toFile();
        File tempStore = this.getServersStoreTempPath().toFile();
        boolean saveFailed = false;
        try {
            outputStream = new FileOutputStream(tempStore);
            LdapServersManagerIO.write(this.serversList, outputStream);
            String content = FileUtils.readFileToString((File)tempStore, (String)"UTF-8");
            FileUtils.writeStringToFile((File)store, (String)content, (String)"UTF-8");
        }
        catch (Exception exception) {
            saveFailed = true;
        }
        if (saveFailed) {
            try {
                outputStream = new FileOutputStream(store);
                LdapServersManagerIO.write(this.serversList, outputStream);
                ((OutputStream)outputStream).close();
            }
            catch (Exception e) {
                CommonUIUtils.openErrorDialog((String)(String.valueOf(Messages.getString("LdapServersManager.ErrorLoadingServer")) + e.getMessage()));
            }
        }
    }

    private IPath getServersStorePath() {
        return LdapServersPlugin.getDefault().getStateLocation().append("ldapServers.xml");
    }

    private IPath getServersStoreTempPath() {
        return LdapServersPlugin.getDefault().getStateLocation().append("ldapServers-temp.xml");
    }

    public boolean isNameAvailable(String name) {
        for (LdapServer serverInstance : this.serversList) {
            if (!serverInstance.getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    public List<LdapServer> getServersList() {
        return this.serversList;
    }

    public LdapServer getServerById(String id) {
        return this.serversIdMap.get(id);
    }

    public static IPath getServersFolder() {
        return LdapServersPlugin.getDefault().getStateLocation().append(SERVERS);
    }

    public static IPath getServerFolder(LdapServer server) {
        if (server != null) {
            return LdapServersManager.getServersFolder().append(server.getId());
        }
        return null;
    }

    public static void createNewServerFolder(LdapServer server) {
        if (server != null) {
            File serverFolder;
            File serversFolder = LdapServersManager.getServersFolder().toFile();
            if (!serversFolder.exists()) {
                serversFolder.mkdir();
            }
            if (!(serverFolder = LdapServersManager.getServerFolder(server).toFile()).exists()) {
                serverFolder.mkdir();
            }
        }
    }

    public static IMemento getMementoForServer(LdapServer server) {
        try {
            if (server != null) {
                File mementoFile = LdapServersManager.getServerFolder(server).append("memento.xml").toFile();
                if (!mementoFile.exists()) {
                    mementoFile.createNewFile();
                }
                XMLMemento readMemento = XMLMemento.createReadRoot((Reader)new FileReader(mementoFile));
                XMLMemento memento = XMLMemento.createWriteRoot((String)"memento");
                memento.putMemento((IMemento)readMemento);
                return memento;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

