/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.clients.problems;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flex.compiler.clients.problems.IProblemFilter;
import org.apache.flex.compiler.clients.problems.ProblemFormatter;
import org.apache.flex.compiler.problems.ICompilerProblem;

public final class ProblemPrinter {
    private ProblemFormatter formatter;
    private OutputStream outputStream;

    public ProblemPrinter(ProblemFormatter formatter, OutputStream outputStream) {
        this.formatter = formatter;
        this.outputStream = outputStream;
    }

    public ProblemPrinter(ProblemFormatter formatter) {
        this(formatter, System.err);
    }

    public int printProblems(Collection<ICompilerProblem> problems, IProblemFilter filter) {
        if (problems == null || problems.isEmpty()) {
            return 0;
        }
        ArrayList<ICompilerProblem> filteredProblems = new ArrayList<ICompilerProblem>();
        for (ICompilerProblem problem : problems) {
            if (filter != null && !filter.accept(problem)) continue;
            filteredProblems.add(problem);
        }
        return this.printProblems(filteredProblems);
    }

    public int printProblems(Iterable<ICompilerProblem> problems) {
        int problemCount = 0;
        PrintWriter writer = new PrintWriter(new PrintStream(this.outputStream));
        for (ICompilerProblem problem : problems) {
            writer.println(this.formatter.format(problem));
            ++problemCount;
        }
        writer.flush();
        return problemCount;
    }
}

