/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions;

import org.apache.flex.compiler.definitions.IGetterDefinition;
import org.apache.flex.compiler.definitions.ISetterDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTag;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.SetterDefinition;
import org.apache.flex.compiler.projects.ICompilerProject;

public class GetterDefinition
extends AccessorDefinition
implements IGetterDefinition {
    public GetterDefinition(String name) {
        super(name);
    }

    @Override
    public ISetterDefinition resolveSetter(ICompilerProject project) {
        return (ISetterDefinition)((Object)this.resolveCorrespondingAccessor(project));
    }

    @Override
    public boolean isSkinPart() {
        return this.getSkinPart() != null;
    }

    @Override
    public boolean isRequiredSkinPart() {
        IMetaTag skinPart = this.getSkinPart();
        if (skinPart == null) {
            return false;
        }
        return this.isRequiredSkinPart(skinPart);
    }

    @Override
    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("function");
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("get");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append('(');
        sb.append(')');
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public FunctionDefinition resolveOverriddenFunction(ICompilerProject project) {
        FunctionDefinition override = super.resolveOverriddenFunction(project);
        if (override instanceof SetterDefinition) {
            override = ((SetterDefinition)override).resolveCorrespondingAccessor(project);
        }
        return override;
    }
}

