/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.common.XMLName;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLRemoteObjectMethodNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.mxml.IMXMLRemoteObjectNode;

class MXMLRemoteObjectNode
extends MXMLInstanceNode
implements IMXMLRemoteObjectNode {
    private static final String TAG_METHOD = "method";
    private static final String BASENAME_REMOTE_OBJECT_METHOD = "RemoteObjectOperation";

    MXMLRemoteObjectNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLRemoteObjectID;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (childTag.getShortName().equals(TAG_METHOD)) {
            FlexProject project = builder.getProject();
            XMLName name = new XMLName(childTag.getXMLName().getXMLNamespace(), BASENAME_REMOTE_OBJECT_METHOD);
            String qname = builder.getFileScope().resolveXMLNameToQualifiedName(name, builder.getMXMLDialect());
            String remoteObjectMethodQName = project.getRemoteObjectMethodQName();
            if (qname != null && qname.equals(remoteObjectMethodQName)) {
                MXMLRemoteObjectMethodNode methodNode = new MXMLRemoteObjectMethodNode(this);
                methodNode.setClassReference(project, remoteObjectMethodQName);
                methodNode.initializeFromTag(builder, childTag);
                info.addChildNode(methodNode);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
    }
}

