/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.io;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.flex.swf.Header;
import org.apache.flex.swf.ISWF;
import org.apache.flex.swf.SWF;
import org.apache.flex.swf.SWFFrame;
import org.apache.flex.swf.TagType;
import org.apache.flex.swf.io.IOutputBitStream;
import org.apache.flex.swf.io.ISWFWriter;
import org.apache.flex.swf.io.ISWFWriterFactory;
import org.apache.flex.swf.io.LZMACompressor;
import org.apache.flex.swf.io.OutputBitStream;
import org.apache.flex.swf.io.SWFReader;
import org.apache.flex.swf.tags.CSMTextSettingsTag;
import org.apache.flex.swf.tags.CharacterTag;
import org.apache.flex.swf.tags.DefineBinaryDataTag;
import org.apache.flex.swf.tags.DefineBitsJPEG2Tag;
import org.apache.flex.swf.tags.DefineBitsJPEG3Tag;
import org.apache.flex.swf.tags.DefineBitsLosslessTag;
import org.apache.flex.swf.tags.DefineBitsTag;
import org.apache.flex.swf.tags.DefineButton2Tag;
import org.apache.flex.swf.tags.DefineButtonSoundTag;
import org.apache.flex.swf.tags.DefineButtonTag;
import org.apache.flex.swf.tags.DefineEditTextTag;
import org.apache.flex.swf.tags.DefineFont2Tag;
import org.apache.flex.swf.tags.DefineFont3Tag;
import org.apache.flex.swf.tags.DefineFont4Tag;
import org.apache.flex.swf.tags.DefineFontAlignZonesTag;
import org.apache.flex.swf.tags.DefineFontInfo2Tag;
import org.apache.flex.swf.tags.DefineFontNameTag;
import org.apache.flex.swf.tags.DefineFontTag;
import org.apache.flex.swf.tags.DefineMorphShape2Tag;
import org.apache.flex.swf.tags.DefineMorphShapeTag;
import org.apache.flex.swf.tags.DefineScalingGridTag;
import org.apache.flex.swf.tags.DefineShape2Tag;
import org.apache.flex.swf.tags.DefineShape3Tag;
import org.apache.flex.swf.tags.DefineShape4Tag;
import org.apache.flex.swf.tags.DefineShapeTag;
import org.apache.flex.swf.tags.DefineSoundTag;
import org.apache.flex.swf.tags.DefineSpriteTag;
import org.apache.flex.swf.tags.DefineText2Tag;
import org.apache.flex.swf.tags.DefineTextTag;
import org.apache.flex.swf.tags.DefineVideoStreamTag;
import org.apache.flex.swf.tags.DoABCTag;
import org.apache.flex.swf.tags.EnableDebugger2Tag;
import org.apache.flex.swf.tags.EnableTelemetryTag;
import org.apache.flex.swf.tags.EndTag;
import org.apache.flex.swf.tags.ExportAssetsTag;
import org.apache.flex.swf.tags.FileAttributesTag;
import org.apache.flex.swf.tags.FrameLabelTag;
import org.apache.flex.swf.tags.IAlwaysLongTag;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.tags.IFontInfo;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.tags.JPEGTablesTag;
import org.apache.flex.swf.tags.MetadataTag;
import org.apache.flex.swf.tags.PlaceObject2Tag;
import org.apache.flex.swf.tags.PlaceObject3Tag;
import org.apache.flex.swf.tags.PlaceObjectTag;
import org.apache.flex.swf.tags.ProductInfoTag;
import org.apache.flex.swf.tags.RawTag;
import org.apache.flex.swf.tags.RemoveObject2Tag;
import org.apache.flex.swf.tags.RemoveObjectTag;
import org.apache.flex.swf.tags.ScriptLimitsTag;
import org.apache.flex.swf.tags.SetBackgroundColorTag;
import org.apache.flex.swf.tags.SetTabIndexTag;
import org.apache.flex.swf.tags.SoundStreamBlockTag;
import org.apache.flex.swf.tags.SoundStreamHead2Tag;
import org.apache.flex.swf.tags.SoundStreamHeadTag;
import org.apache.flex.swf.tags.StartSound2Tag;
import org.apache.flex.swf.tags.StartSoundTag;
import org.apache.flex.swf.tags.SymbolClassTag;
import org.apache.flex.swf.tags.VideoFrameTag;
import org.apache.flex.swf.types.ARGB;
import org.apache.flex.swf.types.BevelFilter;
import org.apache.flex.swf.types.BlurFilter;
import org.apache.flex.swf.types.ButtonRecord;
import org.apache.flex.swf.types.CXForm;
import org.apache.flex.swf.types.CXFormWithAlpha;
import org.apache.flex.swf.types.ConvolutionFilter;
import org.apache.flex.swf.types.CurvedEdgeRecord;
import org.apache.flex.swf.types.DropShadowFilter;
import org.apache.flex.swf.types.EndShapeRecord;
import org.apache.flex.swf.types.FillStyle;
import org.apache.flex.swf.types.FillStyleArray;
import org.apache.flex.swf.types.Filter;
import org.apache.flex.swf.types.FocalGradient;
import org.apache.flex.swf.types.GlowFilter;
import org.apache.flex.swf.types.GlyphEntry;
import org.apache.flex.swf.types.GradRecord;
import org.apache.flex.swf.types.Gradient;
import org.apache.flex.swf.types.GradientBevelFilter;
import org.apache.flex.swf.types.GradientGlowFilter;
import org.apache.flex.swf.types.IFillStyle;
import org.apache.flex.swf.types.ILineStyle;
import org.apache.flex.swf.types.KerningRecord;
import org.apache.flex.swf.types.LineStyle;
import org.apache.flex.swf.types.LineStyle2;
import org.apache.flex.swf.types.LineStyleArray;
import org.apache.flex.swf.types.Matrix;
import org.apache.flex.swf.types.MorphFillStyle;
import org.apache.flex.swf.types.MorphGradRecord;
import org.apache.flex.swf.types.MorphGradient;
import org.apache.flex.swf.types.MorphLineStyle;
import org.apache.flex.swf.types.MorphLineStyle2;
import org.apache.flex.swf.types.RGB;
import org.apache.flex.swf.types.RGBA;
import org.apache.flex.swf.types.Rect;
import org.apache.flex.swf.types.Shape;
import org.apache.flex.swf.types.ShapeRecord;
import org.apache.flex.swf.types.ShapeWithStyle;
import org.apache.flex.swf.types.SoundEnvelope;
import org.apache.flex.swf.types.SoundInfo;
import org.apache.flex.swf.types.StraightEdgeRecord;
import org.apache.flex.swf.types.StyleChangeRecord;
import org.apache.flex.swf.types.Styles;
import org.apache.flex.swf.types.TextRecord;
import org.apache.flex.swf.types.ZoneRecord;

public class SWFWriter
implements ISWFWriter {
    public static final ISWFWriterFactory DEFAULT_SWF_WRITER_FACTORY = new SWFWriterFactory();
    private static final int RESERVED = 0;
    private static final int SHORT_TAG_MAX_LENGTH = 62;
    protected IOutputBitStream tagBuffer;
    private final ISWF swf;
    protected final IOutputBitStream outputBuffer;
    private final Header.Compression useCompression;
    private final boolean enableDebug;
    private final boolean enableTelemetry;
    private int currentFrameIndex;
    private Set<ITag> writtenTags;

    public static int maxNum(int a, int b, int c, int d) {
        a = Math.abs(a);
        b = Math.abs(b);
        c = Math.abs(c);
        d = Math.abs(d);
        return Ints.max((int[])new int[]{a, b, c, d});
    }

    public static double maxNum(double a, double b, double c, double d) {
        a = Math.abs(a);
        b = Math.abs(b);
        c = Math.abs(c);
        d = Math.abs(d);
        return Doubles.max((double[])new double[]{a, b, c, d});
    }

    public static int requireFBCount(double value) {
        return SWFWriter.requireSBCount((int)(value * 65536.0));
    }

    public static int requireSBCount(int value) {
        return SWFWriter.minBits(Math.abs(value), 1);
    }

    public static int requireSBCount(int ... values) {
        int[] array = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = SWFWriter.requireSBCount(values[i]);
        }
        Arrays.sort(array);
        return array[array.length - 1];
    }

    public static int requireUBCount(int value) {
        assert (value >= 0) : "requireUBCount called with negative number";
        return SWFWriter.minBits(value, 0);
    }

    private static int minBits(int number, int bits) {
        int val = 1;
        int x = 1;
        while (val <= number && bits <= 32) {
            val |= x;
            ++bits;
            x <<= 1;
        }
        assert (bits <= 32) : "minBits " + bits + " must not exceed 32";
        return bits;
    }

    private void writeLengthString(String name) {
        block3: {
            try {
                assert (this.tagBuffer.getBitPos() == 8);
                byte[] b = this.swf.getVersion() >= 6 ? name.getBytes("UTF8") : name.getBytes();
                this.tagBuffer.writeUI8(b.length + 1);
                this.tagBuffer.write(b);
                this.tagBuffer.writeUI8(0);
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public SWFWriter(ISWF swf, Header.Compression useCompression) {
        this(swf, useCompression, false, false);
    }

    public SWFWriter(ISWF swf, Header.Compression useCompression, boolean enableDebug, boolean enableTelemetry) {
        this.swf = swf;
        this.useCompression = useCompression;
        this.enableDebug = enableDebug;
        this.enableTelemetry = enableTelemetry;
        this.outputBuffer = new OutputBitStream(false);
        this.tagBuffer = new OutputBitStream(false);
        this.computeCharacterID();
    }

    private void computeCharacterID() {
        int id = 1;
        for (int frameIndex = 0; frameIndex < this.swf.getFrameCount(); ++frameIndex) {
            SWFFrame frame = this.swf.getFrameAt(frameIndex);
            for (ITag tag : frame) {
                if (!(tag instanceof CharacterTag)) continue;
                CharacterTag characterTag = (CharacterTag)tag;
                characterTag.setCharacterID(id);
                ++id;
            }
        }
    }

    protected void finishTag(ITag tag, IOutputBitStream tagData, IOutputBitStream out) {
        tagData.flush();
        int tagLength = tagData.size();
        if (tag instanceof IAlwaysLongTag || tagLength > 62) {
            out.writeUI16(tag.getTagType().getValue() << 6 | 0x3F);
            out.writeSI32(tagLength);
        } else {
            out.writeUI16(tag.getTagType().getValue() << 6 | tagLength);
        }
        out.write(tagData.getBytes(), 0, tagLength);
    }

    public void writeARGB(ARGB argb) {
        this.tagBuffer.writeUI8(argb.getAlpha());
        this.tagBuffer.writeUI8(argb.getRed());
        this.tagBuffer.writeUI8(argb.getGreen());
        this.tagBuffer.writeUI8(argb.getBlue());
    }

    protected void writeCompressibleHeader() {
        Rect rect = this.swf.getFrameSize();
        this.tagBuffer.reset();
        this.writeRect(rect);
        this.outputBuffer.write(this.tagBuffer.getBytes(), 0, this.tagBuffer.size());
        this.outputBuffer.writeFIXED8(this.swf.getFrameRate());
        this.outputBuffer.writeUI16(this.swf.getFrameCount());
    }

    private void writeCurvedEdgeRecord(CurvedEdgeRecord shape) {
        this.tagBuffer.writeBit(true);
        this.tagBuffer.writeBit(false);
        int numBits = shape.getNumBits();
        this.tagBuffer.writeUB(numBits, 4);
        this.tagBuffer.writeSB(shape.getControlDeltaX(), numBits + 2);
        this.tagBuffer.writeSB(shape.getControlDeltaY(), numBits + 2);
        this.tagBuffer.writeSB(shape.getAnchorDeltaX(), numBits + 2);
        this.tagBuffer.writeSB(shape.getAnchorDeltaY(), numBits + 2);
    }

    private void writeDefineBinaryData(DefineBinaryDataTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUI32(0L);
        this.tagBuffer.write(tag.getData());
    }

    private void writeDefineBitsLossless(DefineBitsLosslessTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUI8(tag.getBitmapFormat());
        this.tagBuffer.writeUI16(tag.getBitmapWidth());
        this.tagBuffer.writeUI16(tag.getBitmapHeight());
        if (3 == tag.getBitmapFormat()) {
            this.tagBuffer.writeUI8(tag.getBitmapColorTableSize() - 1);
        }
        this.tagBuffer.write(tag.getZlibBitmapData());
    }

    private void writeDefineShape(DefineShapeTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.writeRect(tag.getShapeBounds());
        this.writeShapeWithStyle(tag.getShapes(), tag.getTagType());
    }

    private void writeDefineShape2(DefineShape2Tag tag) {
        this.writeDefineShape(tag);
    }

    private void writeDefineShape3(DefineShape3Tag tag) {
        this.writeDefineShape2(tag);
    }

    private void writeDefineShape4(DefineShape4Tag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.writeRect(tag.getShapeBounds());
        this.writeRect(tag.getEdgeBounds());
        this.tagBuffer.byteAlign();
        this.tagBuffer.writeUB(0, 5);
        this.tagBuffer.writeBit(tag.isUsesFillWindingRule());
        this.tagBuffer.writeBit(tag.isUsesNonScalingStrokes());
        this.tagBuffer.writeBit(tag.isUsesScalingStrokes());
        this.tagBuffer.byteAlign();
        this.writeShapeWithStyle(tag.getShapes(), tag.getTagType());
    }

    private void writeDefineMorphShape2(DefineMorphShape2Tag tag) {
        this.writeDefineMorphShape(tag);
    }

    private void writeDefineMorphShape(DefineMorphShapeTag tag) {
        IOutputBitStream originalTagBuffer = this.tagBuffer;
        this.tagBuffer = new OutputBitStream();
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.writeRect(tag.getStartBounds());
        this.writeRect(tag.getEndBounds());
        if (TagType.DefineMorphShape2 == tag.getTagType()) {
            DefineMorphShape2Tag tag2 = (DefineMorphShape2Tag)tag;
            this.writeRect(tag2.getStartEdgeBounds());
            this.writeRect(tag2.getEndEdgeBounds());
            this.tagBuffer.writeUB(0, 6);
            this.tagBuffer.writeBit(tag2.isUsesNonScalingStrokes());
            this.tagBuffer.writeBit(tag2.isUsesScalingStrokes());
            this.tagBuffer.byteAlign();
        }
        int sizeBeforeOffset = this.tagBuffer.size();
        Shape startEdges = tag.getStartEdges();
        this.writeShapeWithStyle((ShapeWithStyle)startEdges, tag.getTagType());
        int sizeAfterOffsetToEnd = this.tagBuffer.size() - sizeBeforeOffset;
        originalTagBuffer.write(this.tagBuffer.getBytes(), 0, sizeBeforeOffset);
        originalTagBuffer.writeUI32(sizeAfterOffsetToEnd);
        originalTagBuffer.write(this.tagBuffer.getBytes(), sizeBeforeOffset, sizeAfterOffsetToEnd);
        this.tagBuffer = originalTagBuffer;
        this.writeShape(tag.getEndEdges(), tag.getTagType(), 0, 0);
    }

    private void writeShape(Shape shape, TagType tagType, int fillStyleCount, int lineStyleCount) {
        SWFReader.CurrentStyles currentStyles = new SWFReader.CurrentStyles();
        currentStyles.numFillBits = SWFWriter.requireUBCount(fillStyleCount);
        currentStyles.numLineBits = SWFWriter.requireUBCount(lineStyleCount);
        this.writeShape(shape, tagType, currentStyles);
    }

    private void writeShape(Shape shape, TagType tagType, SWFReader.CurrentStyles currentStyles) {
        this.tagBuffer.writeUB(currentStyles.numFillBits, 4);
        this.tagBuffer.writeUB(currentStyles.numLineBits, 4);
        for (ShapeRecord shapeRecord : shape.getShapeRecords()) {
            this.writeShapeRecord(shapeRecord, tagType, currentStyles);
        }
        this.writeShapeRecord(new EndShapeRecord(), tagType, currentStyles);
        this.tagBuffer.byteAlign();
    }

    private void writeMorphLineStyle(MorphLineStyle lineStyle) {
        this.tagBuffer.writeUI16(lineStyle.getStartWidth());
        this.tagBuffer.writeUI16(lineStyle.getEndWidth());
        this.writeRGBA(lineStyle.getStartColor());
        this.writeRGBA(lineStyle.getEndColor());
    }

    private void writeMorphLineStyle2(MorphLineStyle2 lineStyle, TagType tagType) {
        this.tagBuffer.writeUI16(lineStyle.getStartWidth());
        this.tagBuffer.writeUI16(lineStyle.getEndWidth());
        this.tagBuffer.writeUB(lineStyle.getStartCapStyle(), 2);
        this.tagBuffer.writeUB(lineStyle.getJoinStyle(), 2);
        this.tagBuffer.writeBit(lineStyle.isHasFillFlag());
        this.tagBuffer.writeBit(lineStyle.isNoHScaleFlag());
        this.tagBuffer.writeBit(lineStyle.isNoVScaleFlag());
        this.tagBuffer.writeBit(lineStyle.isPixelHintingFlag());
        this.tagBuffer.writeUB(0, 5);
        this.tagBuffer.writeBit(lineStyle.isNoClose());
        this.tagBuffer.writeUB(lineStyle.getEndCapStyle(), 2);
        if (lineStyle.getJoinStyle() == 2) {
            this.tagBuffer.writeUI16(lineStyle.getMiterLimitFactor());
        }
        if (!lineStyle.isHasFillFlag()) {
            this.writeRGBA(lineStyle.getStartColor());
            this.writeRGBA(lineStyle.getEndColor());
        } else {
            this.writeMorphFillStyle(lineStyle.getFillType(), tagType);
        }
    }

    private void writeMorphFillStyle(MorphFillStyle fillStyle, TagType tagType) {
        int fillStyleType = fillStyle.getFillStyleType();
        this.tagBuffer.writeUI8(fillStyleType);
        switch (fillStyle.getFillStyleType()) {
            case 0: {
                this.writeRGBA(fillStyle.getStartColor());
                this.writeRGBA(fillStyle.getEndColor());
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                this.writeMatrix(fillStyle.getStartGradientMatrix());
                this.writeMatrix(fillStyle.getEndGradientMatrix());
                this.writeMorphGradient(fillStyle.getGradient());
                if (fillStyleType != 19 || tagType.getValue() != TagType.DefineMorphShape2.getValue()) break;
                this.tagBuffer.writeSI16(fillStyle.getRatio1());
                this.tagBuffer.writeSI16(fillStyle.getRatio2());
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.tagBuffer.writeUI16(fillStyle.getBitmap().getCharacterID());
                this.writeMatrix(fillStyle.getStartBitmapMatrix());
                this.writeMatrix(fillStyle.getEndBitmapMatrix());
            }
        }
    }

    private void writeMorphGradient(MorphGradient gradient) {
        this.tagBuffer.writeUI8(gradient.size());
        for (MorphGradRecord morphGradRecord : gradient) {
            this.writeMorphGradRecord(morphGradRecord);
        }
    }

    private void writeMorphGradRecord(MorphGradRecord morphGradRecord) {
        this.tagBuffer.writeUI8(morphGradRecord.getStartRatio());
        this.writeRGBA(morphGradRecord.getStartColor());
        this.tagBuffer.writeUI8(morphGradRecord.getEndRatio());
        this.writeRGBA(morphGradRecord.getEndColor());
    }

    private void writeExtensibleCount(int count) {
        if (count < 255) {
            this.tagBuffer.writeUI8(count);
        } else {
            this.tagBuffer.writeUI8(255);
            this.tagBuffer.writeUI16(count);
        }
    }

    public void writeDoABC(DoABCTag tag) {
        assert (this.swf.getUseAS3()) : "DoABC tag requires FileAttributes.Actionscript3=true.";
        this.tagBuffer.writeUI32(tag.getFlags());
        this.tagBuffer.writeString(tag.getName());
        this.tagBuffer.write(tag.getABCData());
    }

    private void writeEnableDebugger2(EnableDebugger2Tag tag) {
        this.tagBuffer.writeUI16(0);
        this.tagBuffer.writeString(tag.getPassword());
    }

    private void writeEnableTelemetry(EnableTelemetryTag tag) {
        this.tagBuffer.writeUI16(0);
        if (tag.getPassword() != null) {
            this.tagBuffer.writeString(tag.getPassword());
        }
    }

    private void writeEnd() {
    }

    private void writeEndShapeRecord(EndShapeRecord shape) {
        this.tagBuffer.writeBit(shape.getTypeFlag());
        this.tagBuffer.writeUB(0, 5);
    }

    public void writeFileAttributes(FileAttributesTag tag) {
        this.tagBuffer.writeBit(false);
        this.tagBuffer.writeBit(tag.isUseDirectBlit());
        this.tagBuffer.writeBit(tag.isUseGPU());
        this.tagBuffer.writeBit(tag.isHasMetadata());
        this.tagBuffer.writeBit(tag.isAS3());
        this.tagBuffer.writeUB(0, 2);
        this.tagBuffer.writeBit(tag.isUseNetwork());
        this.tagBuffer.writeUB(0, 24);
        this.tagBuffer.byteAlign();
    }

    private void writeFillStyle(IFillStyle fillStyle, TagType tagType) {
        if (fillStyle instanceof FillStyle) {
            this.writeFillStyle((FillStyle)fillStyle, tagType);
        } else if (fillStyle instanceof MorphFillStyle) {
            this.writeMorphFillStyle((MorphFillStyle)fillStyle, tagType);
        } else assert (false);
    }

    private void writeFillStyle(FillStyle fillStyle, TagType tagType) {
        assert (fillStyle != null);
        int fillStyleType = fillStyle.getFillStyleType();
        this.tagBuffer.writeUI8(fillStyleType);
        block0 : switch (fillStyleType) {
            case 0: {
                switch (tagType) {
                    case DefineShape3: 
                    case DefineShape4: {
                        this.writeRGBA((RGBA)fillStyle.getColor());
                        break block0;
                    }
                    case DefineShape: 
                    case DefineShape2: {
                        this.writeRGB(fillStyle.getColor());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid tag: " + (Object)((Object)tagType));
            }
            case 16: 
            case 18: {
                this.writeMatrix(fillStyle.getGradientMatrix());
                this.writeGradient(fillStyle.getGradient(), tagType);
                break;
            }
            case 19: {
                this.writeMatrix(fillStyle.getGradientMatrix());
                this.writeFocalGradient((FocalGradient)fillStyle.getGradient(), tagType);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.tagBuffer.writeUI16(fillStyle.getBitmapCharacter().getCharacterID());
                this.writeMatrix(fillStyle.getBitmapMatrix());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid FillStyleType: " + fillStyleType);
            }
        }
    }

    private void writeFillStyles(FillStyleArray fillStyles, TagType tagType) {
        assert (fillStyles != null);
        int fillStyleCount = fillStyles.size();
        this.writeExtensibleCount(fillStyleCount);
        for (IFillStyle fillStyle : fillStyles) {
            this.writeFillStyle(fillStyle, tagType);
        }
    }

    private void writeFocalGradient(FocalGradient gradient, TagType tagType) {
        assert (TagType.DefineShape4 == tagType);
        this.writeGradient(gradient, tagType);
        this.tagBuffer.writeFIXED8(gradient.getFocalPoint());
    }

    private void writeFrames() {
        this.currentFrameIndex = 0;
        while (this.currentFrameIndex < this.swf.getFrameCount()) {
            SWFFrame frame = this.swf.getFrameAt(this.currentFrameIndex);
            if (0 == this.currentFrameIndex && null != this.swf.getTopLevelClass()) {
                SWFFrame.forceSymbolClassTag(frame);
            }
            for (ITag tag : frame) {
                this.writeTag(tag);
            }
            ++this.currentFrameIndex;
        }
    }

    private void writeGradient(Gradient gradient, TagType tagType) {
        assert (gradient != null);
        assert (gradient.getGradientRecords() != null);
        this.tagBuffer.writeUB(gradient.getSpreadMode(), 2);
        this.tagBuffer.writeUB(gradient.getInterpolationMode(), 2);
        this.tagBuffer.writeUB(gradient.getGradientRecords().size(), 4);
        this.tagBuffer.byteAlign();
        for (GradRecord gradRecord : gradient.getGradientRecords()) {
            this.writeGradRecord(gradRecord, tagType);
        }
    }

    private void writeGradRecord(GradRecord gradRecord, TagType tagType) {
        assert (gradRecord != null);
        this.tagBuffer.writeUI8(gradRecord.getRatio());
        switch (tagType) {
            case DefineShape: 
            case DefineShape2: {
                this.writeRGB(gradRecord.getColor());
                break;
            }
            case DefineShape3: 
            case DefineShape4: {
                this.writeRGBA((RGBA)gradRecord.getColor());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tag: " + (Object)((Object)tagType));
            }
        }
    }

    private void writeLineStyle(LineStyle lineStyle, TagType tagType) {
        assert (lineStyle != null);
        this.tagBuffer.writeUI16(lineStyle.getWidth());
        switch (tagType) {
            case DefineShape: 
            case DefineShape2: {
                this.writeRGB(lineStyle.getColor());
                break;
            }
            case DefineShape3: {
                this.writeRGBA((RGBA)lineStyle.getColor());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tag: " + (Object)((Object)tagType));
            }
        }
    }

    private void writeLineStyle2(LineStyle2 lineStyle, TagType tagType) {
        assert (lineStyle != null);
        this.tagBuffer.writeUI16(lineStyle.getWidth());
        this.tagBuffer.writeUB(lineStyle.getStartCapStyle(), 2);
        this.tagBuffer.writeUB(lineStyle.getJoinStyle(), 2);
        this.tagBuffer.writeBit(lineStyle.isHasFillFlag());
        this.tagBuffer.writeBit(lineStyle.isNoHScaleFlag());
        this.tagBuffer.writeBit(lineStyle.isNoVScaleFlag());
        this.tagBuffer.writeBit(lineStyle.isPixelHintingFlag());
        this.tagBuffer.writeUB(0, 5);
        this.tagBuffer.writeBit(lineStyle.isNoClose());
        this.tagBuffer.writeUB(lineStyle.getEndCapStyle(), 2);
        this.tagBuffer.byteAlign();
        if (2 == lineStyle.getJoinStyle()) {
            this.tagBuffer.writeFIXED8(lineStyle.getMiterLimitFactor());
        }
        if (lineStyle.isHasFillFlag()) {
            this.writeFillStyle(lineStyle.getFillType(), tagType);
        } else {
            this.writeRGBA((RGBA)lineStyle.getColor());
        }
    }

    private void writeLineStyles(LineStyleArray lineStyles, TagType tagType) {
        assert (lineStyles != null);
        int lineStyleCount = lineStyles.size();
        this.writeExtensibleCount(lineStyleCount);
        block6: for (ILineStyle lineStyle : lineStyles) {
            switch (tagType) {
                case DefineShape3: 
                case DefineShape: 
                case DefineShape2: {
                    this.writeLineStyle((LineStyle)lineStyle, tagType);
                    continue block6;
                }
                case DefineShape4: {
                    this.writeLineStyle2((LineStyle2)lineStyle, tagType);
                    continue block6;
                }
                case DefineMorphShape2: {
                    this.writeMorphLineStyle2((MorphLineStyle2)lineStyle, tagType);
                    continue block6;
                }
                case DefineMorphShape: {
                    this.writeMorphLineStyle((MorphLineStyle)lineStyle);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Invalid tag: " + (Object)((Object)tagType));
        }
    }

    private void writeMatrix(Matrix matrix) {
        this.tagBuffer.writeBit(matrix.hasScale());
        if (matrix.hasScale()) {
            double scaleX = matrix.getScaleX();
            double scaleY = matrix.getScaleY();
            int nScaleBits = SWFWriter.requireFBCount(SWFWriter.maxNum(scaleX, scaleY, 0.0, 0.0));
            this.tagBuffer.writeUB(nScaleBits, 5);
            this.tagBuffer.writeFB(scaleX, nScaleBits);
            this.tagBuffer.writeFB(scaleY, nScaleBits);
        }
        this.tagBuffer.writeBit(matrix.hasRotate());
        if (matrix.hasRotate()) {
            double rotateSkew0 = matrix.getRotateSkew0();
            double rotateSkew1 = matrix.getRotateSkew1();
            int nRotateBits = SWFWriter.requireFBCount(SWFWriter.maxNum(rotateSkew0, rotateSkew1, 0.0, 0.0));
            this.tagBuffer.writeUB(nRotateBits, 5);
            this.tagBuffer.writeFB(rotateSkew0, nRotateBits);
            this.tagBuffer.writeFB(rotateSkew1, nRotateBits);
        }
        int translateX = matrix.getTranslateX();
        int translateY = matrix.getTranslateY();
        int nTranslateBits = SWFWriter.requireSBCount(SWFWriter.maxNum(translateX, translateY, 0, 0));
        this.tagBuffer.writeUB(nTranslateBits, 5);
        this.tagBuffer.writeSB(translateX, nTranslateBits);
        this.tagBuffer.writeSB(translateY, nTranslateBits);
        this.tagBuffer.byteAlign();
    }

    private void writeMetadata(MetadataTag tag) {
        this.tagBuffer.writeString(tag.getMetadata());
    }

    private void writeProductInfo(ProductInfoTag tag) {
        this.tagBuffer.writeUI32(tag.getProduct().getCode());
        this.tagBuffer.writeUI32(tag.getEdition().getCode());
        this.tagBuffer.writeUI8(tag.getMajorVersion());
        this.tagBuffer.writeUI8(tag.getMinorVersion());
        this.tagBuffer.writeSI64(tag.getBuild());
        this.tagBuffer.writeSI64(tag.getCompileDate());
    }

    public void writeRect(Rect rect) {
        int maxRectNum = SWFWriter.maxNum(rect.xMin(), rect.xMax(), rect.yMin(), rect.yMax());
        int nbits = SWFWriter.requireSBCount(maxRectNum);
        this.tagBuffer.writeUB(nbits, 5);
        this.tagBuffer.writeSB(rect.xMin(), nbits);
        this.tagBuffer.writeSB(rect.xMax(), nbits);
        this.tagBuffer.writeSB(rect.yMin(), nbits);
        this.tagBuffer.writeSB(rect.yMax(), nbits);
        this.tagBuffer.byteAlign();
    }

    public void writeRGB(RGB rgb) {
        this.tagBuffer.writeUI8(rgb.getRed());
        this.tagBuffer.writeUI8(rgb.getGreen());
        this.tagBuffer.writeUI8(rgb.getBlue());
    }

    public void writeRGBA(RGBA rgba) {
        this.tagBuffer.writeUI8(rgba.getRed());
        this.tagBuffer.writeUI8(rgba.getGreen());
        this.tagBuffer.writeUI8(rgba.getBlue());
        this.tagBuffer.writeUI8(rgba.getAlpha());
    }

    private void writeScriptLimits(ScriptLimitsTag tag) {
        this.tagBuffer.writeUI16(tag.getMaxRecursionDepth());
        this.tagBuffer.writeUI16(tag.getScriptTimeoutSeconds());
    }

    private void writeSetBackgroundColor(SetBackgroundColorTag tag) {
        this.writeRGB(tag.getColor());
    }

    private void writeShapeRecord(ShapeRecord shape, TagType tagType, SWFReader.CurrentStyles currentStyles) {
        switch (shape.getShapeRecordType()) {
            case END_SHAPE: {
                this.writeEndShapeRecord((EndShapeRecord)shape);
                break;
            }
            case CURVED_EDGE: {
                this.writeCurvedEdgeRecord((CurvedEdgeRecord)shape);
                break;
            }
            case STRAIGHT_EDGE: {
                this.writeStraightEdgeRecord((StraightEdgeRecord)shape);
                break;
            }
            case STYLE_CHANGE: {
                this.writeStyleChangeRecord((StyleChangeRecord)shape, tagType, currentStyles);
            }
        }
    }

    private void writeShapeWithStyle(ShapeWithStyle shape, TagType tagType) {
        this.writeFillStyles(shape.getFillStyles(), tagType);
        this.writeLineStyles(shape.getLineStyles(), tagType);
        SWFReader.CurrentStyles currentStyles = new SWFReader.CurrentStyles();
        currentStyles.styles = new Styles(shape.getFillStyles(), shape.getLineStyles());
        currentStyles.numFillBits = SWFWriter.requireUBCount(shape.getFillStyles().size());
        currentStyles.numLineBits = SWFWriter.requireUBCount(shape.getLineStyles().size());
        this.writeShape(shape, tagType, currentStyles);
    }

    private void writeShowFrame() {
    }

    private void writeStraightEdgeRecord(StraightEdgeRecord shape) {
        this.tagBuffer.writeBit(true);
        this.tagBuffer.writeBit(true);
        int numBits = shape.getNumBits();
        this.tagBuffer.writeUB(numBits, 4);
        switch (shape.getLineType()) {
            case GENERAL: {
                this.tagBuffer.writeBit(true);
                this.tagBuffer.writeSB(shape.getDeltaX(), numBits + 2);
                this.tagBuffer.writeSB(shape.getDeltaY(), numBits + 2);
                break;
            }
            case VERTICAL: {
                this.tagBuffer.writeBit(false);
                this.tagBuffer.writeBit(true);
                this.tagBuffer.writeSB(shape.getDeltaY(), numBits + 2);
                break;
            }
            case HORIZONTAL: {
                this.tagBuffer.writeBit(false);
                this.tagBuffer.writeBit(false);
                this.tagBuffer.writeSB(shape.getDeltaX(), numBits + 2);
            }
        }
    }

    private void writeStyleChangeRecord(StyleChangeRecord shape, TagType tagType, SWFReader.CurrentStyles currentStyles) {
        boolean ignoreStyle;
        this.tagBuffer.writeBit(shape.getTypeFlag());
        this.tagBuffer.writeBit(shape.isStateNewStyles());
        this.tagBuffer.writeBit(shape.isStateLineStyle());
        this.tagBuffer.writeBit(shape.isStateFillStyle1());
        this.tagBuffer.writeBit(shape.isStateFillStyle0());
        this.tagBuffer.writeBit(shape.isStateMoveTo());
        if (shape.isStateMoveTo()) {
            int moveBits = SWFWriter.requireSBCount(SWFWriter.maxNum(shape.getMoveDeltaX(), shape.getMoveDeltaY(), 0, 0));
            this.tagBuffer.writeUB(moveBits, 5);
            this.tagBuffer.writeSB(shape.getMoveDeltaX(), moveBits);
            this.tagBuffer.writeSB(shape.getMoveDeltaY(), moveBits);
        }
        boolean bl = ignoreStyle = tagType == TagType.DefineFont || tagType == TagType.DefineFont2 || tagType == TagType.DefineFont3;
        if (shape.isStateFillStyle0()) {
            int fs0 = ignoreStyle ? 1 : currentStyles.styles.getFillStyles().indexOf(shape.getFillstyle0()) + 1;
            this.tagBuffer.writeUB(fs0, currentStyles.numFillBits);
        }
        if (shape.isStateFillStyle1()) {
            int fs1 = ignoreStyle ? 1 : currentStyles.styles.getFillStyles().indexOf(shape.getFillstyle1()) + 1;
            this.tagBuffer.writeUB(fs1, currentStyles.numFillBits);
        }
        if (shape.isStateLineStyle()) {
            int ls = ignoreStyle ? 0 : currentStyles.styles.getLineStyles().indexOf(shape.getLinestyle()) + 1;
            this.tagBuffer.writeUB(ls, currentStyles.numLineBits);
        }
        if (shape.isStateNewStyles()) {
            this.tagBuffer.byteAlign();
            this.writeFillStyles(shape.getStyles().getFillStyles(), tagType);
            this.writeLineStyles(shape.getStyles().getLineStyles(), tagType);
            int nFillBits = shape.getNumFillBits();
            int nLineBits = shape.getNumLineBits();
            this.tagBuffer.writeUB(nFillBits, 4);
            this.tagBuffer.writeUB(nLineBits, 4);
            currentStyles.styles = shape.getStyles();
            currentStyles.numFillBits = nFillBits;
            currentStyles.numLineBits = nLineBits;
        }
    }

    private void writeSymbolClass(SymbolClassTag tag) {
        boolean writeRootClass = this.currentFrameIndex == 0 && this.swf.getTopLevelClass() != null;
        int count = writeRootClass ? tag.size() + 1 : tag.size();
        this.tagBuffer.writeUI16(count);
        for (String symbolName : tag.getSymbolNames()) {
            ICharacterTag characterTag = tag.getSymbol(symbolName);
            this.tagBuffer.writeUI16(characterTag.getCharacterID());
            this.tagBuffer.writeString(symbolName);
        }
        if (writeRootClass) {
            this.tagBuffer.writeUI16(0);
            this.tagBuffer.writeString(this.swf.getTopLevelClass());
        }
    }

    private void writeTag(ITag tag) {
        if (!this.writtenTags.contains(tag)) {
            this.tagBuffer.reset();
            this.writeTag(tag, this.tagBuffer, this.outputBuffer);
            this.writtenTags.add(tag);
        }
    }

    private void writeTag(ITag tag, IOutputBitStream tagData, IOutputBitStream out) {
        assert (tag != null);
        assert (tagData != null);
        assert (out != null);
        assert (tagData != out);
        if (tag == SWFReader.INVALID_TAG) {
            return;
        }
        IOutputBitStream swfTagBuffer = null;
        if (tagData != this.tagBuffer) {
            swfTagBuffer = this.tagBuffer;
            this.tagBuffer = tagData;
        }
        boolean skipRawTag = false;
        LinkedList<ITag> extraTags = new LinkedList<ITag>();
        if (tag instanceof RawTag) {
            skipRawTag = this.writeRawTag((RawTag)tag);
        } else {
            switch (tag.getTagType()) {
                case DoABC: {
                    this.writeDoABC((DoABCTag)tag);
                    break;
                }
                case FileAttributes: {
                    this.writeFileAttributes((FileAttributesTag)tag);
                    break;
                }
                case SymbolClass: {
                    this.writeSymbolClass((SymbolClassTag)tag);
                    break;
                }
                case ShowFrame: {
                    this.writeShowFrame();
                    break;
                }
                case SetBackgroundColor: {
                    this.writeSetBackgroundColor((SetBackgroundColorTag)tag);
                    break;
                }
                case EnableDebugger2: {
                    this.writeEnableDebugger2((EnableDebugger2Tag)tag);
                    break;
                }
                case EnableTelemetry: {
                    this.writeEnableTelemetry((EnableTelemetryTag)tag);
                    break;
                }
                case ScriptLimits: {
                    this.writeScriptLimits((ScriptLimitsTag)tag);
                    break;
                }
                case ProductInfo: {
                    this.writeProductInfo((ProductInfoTag)tag);
                    break;
                }
                case Metadata: {
                    this.writeMetadata((MetadataTag)tag);
                    break;
                }
                case DefineBits: {
                    this.writeDefineBits((DefineBitsTag)tag);
                    break;
                }
                case DefineBitsJPEG2: {
                    this.writeDefineBitsJPEG2((DefineBitsJPEG2Tag)tag);
                    break;
                }
                case DefineBitsJPEG3: {
                    this.writeDefineBitsJPEG3((DefineBitsJPEG3Tag)tag);
                    break;
                }
                case DefineBitsLossless: 
                case DefineBitsLossless2: {
                    this.writeDefineBitsLossless((DefineBitsLosslessTag)tag);
                    break;
                }
                case DefineBinaryData: {
                    this.writeDefineBinaryData((DefineBinaryDataTag)tag);
                    break;
                }
                case DefineShape: {
                    this.writeDefineShape((DefineShapeTag)tag);
                    break;
                }
                case DefineShape2: {
                    this.writeDefineShape2((DefineShape2Tag)tag);
                    break;
                }
                case DefineShape3: {
                    this.writeDefineShape3((DefineShape3Tag)tag);
                    break;
                }
                case DefineShape4: {
                    this.writeDefineShape4((DefineShape4Tag)tag);
                    break;
                }
                case DefineSprite: {
                    this.writeDefineSprite((DefineSpriteTag)tag);
                    break;
                }
                case ExportAssets: {
                    this.writeExportAssets((ExportAssetsTag)tag);
                    break;
                }
                case DefineScalingGrid: {
                    this.writeDefineScalingGrid((DefineScalingGridTag)tag);
                    break;
                }
                case DefineFont: {
                    this.writeDefineFont((DefineFontTag)tag, extraTags);
                    break;
                }
                case DefineFont2: {
                    this.writeDefineFont2((DefineFont2Tag)tag, extraTags);
                    break;
                }
                case DefineFont3: {
                    this.writeDefineFont3((DefineFont3Tag)tag, extraTags);
                    break;
                }
                case DefineFont4: {
                    this.writeDefineFont4((DefineFont4Tag)tag, extraTags);
                    break;
                }
                case DefineFontInfo: {
                    this.writeDefineFontInfo((IFontInfo)((Object)tag));
                    break;
                }
                case DefineFontInfo2: {
                    this.writeDefineFontInfo2((DefineFontInfo2Tag)tag);
                    break;
                }
                case DefineFontAlignZones: {
                    this.writeDefineFontAlignZones((DefineFontAlignZonesTag)tag);
                    break;
                }
                case DefineFontName: {
                    this.writeDefineFontName((DefineFontNameTag)tag);
                    break;
                }
                case DefineText: {
                    this.writeDefineText((DefineTextTag)tag, extraTags);
                    break;
                }
                case DefineText2: {
                    this.writeDefineText2((DefineText2Tag)tag, extraTags);
                    break;
                }
                case DefineEditText: {
                    this.writeDefineEditText((DefineEditTextTag)tag, extraTags);
                    break;
                }
                case DefineSound: {
                    this.writeDefineSound((DefineSoundTag)tag);
                    break;
                }
                case DefineVideoStream: {
                    this.writeDefineVideoStream((DefineVideoStreamTag)tag);
                    break;
                }
                case VideoFrame: {
                    this.writeVideoFrame((VideoFrameTag)tag);
                    break;
                }
                case StartSound: {
                    this.writeStartSound((StartSoundTag)tag);
                    break;
                }
                case StartSound2: {
                    this.writeStartSound2((StartSound2Tag)tag);
                    break;
                }
                case SoundStreamHead: {
                    this.writeSoundStreamHead((SoundStreamHeadTag)tag);
                    break;
                }
                case SoundStreamHead2: {
                    this.writeSoundStreamHead((SoundStreamHead2Tag)tag);
                    break;
                }
                case SoundStreamBlock: {
                    this.writeSoundStreamBlock((SoundStreamBlockTag)tag);
                    break;
                }
                case DefineButton: {
                    this.writeDefineButton((DefineButtonTag)tag);
                    break;
                }
                case DefineButton2: {
                    this.writeDefineButton2((DefineButton2Tag)tag);
                    break;
                }
                case DefineButtonSound: {
                    this.writeDefineButtonSound((DefineButtonSoundTag)tag);
                    break;
                }
                case CSMTextSettings: {
                    this.writeCSMTextSettings((CSMTextSettingsTag)tag);
                    break;
                }
                case End: {
                    this.writeEnd();
                    break;
                }
                case JPEGTables: {
                    this.writeJPEGTables((JPEGTablesTag)tag);
                    break;
                }
                case DefineMorphShape: {
                    this.writeDefineMorphShape((DefineMorphShapeTag)tag);
                    break;
                }
                case DefineMorphShape2: {
                    this.writeDefineMorphShape2((DefineMorphShape2Tag)tag);
                    break;
                }
                case PlaceObject: {
                    this.writePlaceObject((PlaceObjectTag)tag);
                    break;
                }
                case PlaceObject2: {
                    this.writePlaceObject2((PlaceObject2Tag)tag);
                    break;
                }
                case PlaceObject3: {
                    this.writePlaceObject3((PlaceObject3Tag)tag);
                    break;
                }
                case RemoveObject: {
                    this.writeRemoveObject((RemoveObjectTag)tag);
                    break;
                }
                case RemoveObject2: {
                    this.writeRemoveObject2((RemoveObject2Tag)tag);
                    break;
                }
                case SetTabIndex: {
                    this.writeSetTabIndex((SetTabIndexTag)tag);
                    break;
                }
                case FrameLabel: {
                    this.writeFrameLabel((FrameLabelTag)tag);
                    break;
                }
                default: {
                    throw new RuntimeException("Tag not supported: " + tag);
                }
            }
        }
        if (swfTagBuffer != null) {
            this.tagBuffer = swfTagBuffer;
        }
        if (!skipRawTag) {
            this.finishTag(tag, tagData, out);
        }
        for (ITag extraTag : extraTags) {
            this.writeTag(extraTag);
        }
    }

    private boolean writeRawTag(RawTag tag) {
        boolean skipTag = false;
        if (this.swf.getUseAS3()) {
            switch (tag.getTagType()) {
                case DoAction: 
                case DoInitAction: {
                    skipTag = true;
                }
            }
        }
        if (!skipTag) {
            this.tagBuffer.write(tag.getTagBody());
        }
        return skipTag;
    }

    private void writeSetTabIndex(SetTabIndexTag tag) {
        this.tagBuffer.writeUI16(tag.getDepth());
        this.tagBuffer.writeUI16(tag.getTabIndex());
    }

    private void writeRemoveObject2(RemoveObject2Tag tag) {
        this.tagBuffer.writeUI16(tag.getDepth());
    }

    private void writeRemoveObject(RemoveObjectTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacter().getCharacterID());
        this.tagBuffer.writeUI16(tag.getDepth());
    }

    private void writePlaceObject(PlaceObjectTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacter().getCharacterID());
        this.tagBuffer.writeUI16(tag.getDepth());
        this.writeMatrix(tag.getMatrix());
        CXForm colorTransform = tag.getColorTransform();
        if (colorTransform != null) {
            this.writeColorTransform(colorTransform);
        }
    }

    private void writeColorTransform(CXForm cx) {
        int nbits = SWFWriter.requireSBCount(cx.getRedMultTerm(), cx.getGreenMultTerm(), cx.getBlueMultTerm(), cx.getRedAddTerm(), cx.getGreenAddTerm(), cx.getBlueAddTerm());
        this.tagBuffer.writeBit(cx.hasAdd());
        this.tagBuffer.writeBit(cx.hasMult());
        this.tagBuffer.writeUB(nbits, 4);
        if (cx.hasMult()) {
            this.tagBuffer.writeSB(cx.getRedMultTerm(), nbits);
            this.tagBuffer.writeSB(cx.getGreenMultTerm(), nbits);
            this.tagBuffer.writeSB(cx.getBlueMultTerm(), nbits);
        }
        if (cx.hasAdd()) {
            this.tagBuffer.writeSB(cx.getRedAddTerm(), nbits);
            this.tagBuffer.writeSB(cx.getGreenAddTerm(), nbits);
            this.tagBuffer.writeSB(cx.getBlueAddTerm(), nbits);
        }
        this.tagBuffer.byteAlign();
    }

    private void writePlaceObject2(PlaceObject2Tag tag) {
        this.tagBuffer.writeBit(tag.isHasClipActions());
        this.tagBuffer.writeBit(tag.isHasClipDepth());
        this.tagBuffer.writeBit(tag.isHasName());
        this.tagBuffer.writeBit(tag.isHasRatio());
        this.tagBuffer.writeBit(tag.isHasColorTransform());
        this.tagBuffer.writeBit(tag.isHasMatrix());
        this.tagBuffer.writeBit(tag.isHasCharacter());
        this.tagBuffer.writeBit(tag.isMove());
        this.tagBuffer.writeUI16(tag.getDepth());
        if (tag.isHasCharacter()) {
            this.tagBuffer.writeUI16(tag.getCharacter().getCharacterID());
        }
        if (tag.isHasMatrix()) {
            this.writeMatrix(tag.getMatrix());
        }
        if (tag.isHasColorTransform()) {
            this.writeColorTransformWithAlpha(tag.getColorTransform());
        }
        if (tag.isHasRatio()) {
            this.tagBuffer.writeUI16(tag.getRatio());
        }
        if (tag.isHasName()) {
            this.tagBuffer.writeString(tag.getName());
        }
        if (tag.isHasClipDepth()) {
            this.tagBuffer.writeUI16(tag.getClipDepth());
        }
        if (tag.isHasClipActions()) {
            this.tagBuffer.write(tag.getClipActions().data);
        }
    }

    private void writePlaceObject3(PlaceObject3Tag tag) {
        this.tagBuffer.writeBit(tag.isHasClipActions());
        this.tagBuffer.writeBit(tag.isHasClipDepth());
        this.tagBuffer.writeBit(tag.isHasName());
        this.tagBuffer.writeBit(tag.isHasRatio());
        this.tagBuffer.writeBit(tag.isHasColorTransform());
        this.tagBuffer.writeBit(tag.isHasMatrix());
        this.tagBuffer.writeBit(tag.isHasCharacter());
        this.tagBuffer.writeBit(tag.isMove());
        this.tagBuffer.writeUB(0, 3);
        this.tagBuffer.writeBit(tag.isHasImage());
        this.tagBuffer.writeBit(tag.isHasClassName());
        this.tagBuffer.writeBit(tag.isHasCacheAsBitmap());
        this.tagBuffer.writeBit(tag.isHasBlendMode());
        this.tagBuffer.writeBit(tag.isHasFilterList());
        this.tagBuffer.writeUI16(tag.getDepth());
        if (tag.isHasClassName()) {
            this.tagBuffer.writeString(tag.getClassName());
        }
        if (tag.isHasCharacter()) {
            this.tagBuffer.writeUI16(tag.getCharacter().getCharacterID());
        }
        if (tag.isHasMatrix()) {
            this.writeMatrix(tag.getMatrix());
        }
        if (tag.isHasColorTransform()) {
            this.writeColorTransformWithAlpha(tag.getColorTransform());
        }
        if (tag.isHasRatio()) {
            this.tagBuffer.writeUI16(tag.getRatio());
        }
        if (tag.isHasName()) {
            this.tagBuffer.writeString(tag.getName());
        }
        if (tag.isHasClipDepth()) {
            this.tagBuffer.writeUI16(tag.getClipDepth());
        }
        if (tag.isHasFilterList()) {
            this.tagBuffer.writeUI8(tag.getSurfaceFilterList().length);
            for (Filter filter : tag.getSurfaceFilterList()) {
                this.writeFilter(filter);
            }
        }
        if (tag.isHasBlendMode()) {
            this.tagBuffer.writeUI8(tag.getBlendMode());
        }
        if (tag.isHasCacheAsBitmap()) {
            this.tagBuffer.writeUI8(tag.getBitmapCache());
        }
        if (tag.isHasClipActions()) {
            this.tagBuffer.write(tag.getClipActions().data);
        }
    }

    private void writeVideoFrame(VideoFrameTag tag) {
        this.tagBuffer.writeUI16(tag.getStreamTag().getCharacterID());
        this.tagBuffer.writeUI16(tag.getFrameNum());
        this.tagBuffer.write(tag.getVideoData());
    }

    private void writeDefineVideoStream(DefineVideoStreamTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUI16(tag.getNumFrames());
        this.tagBuffer.writeUI16(tag.getWidth());
        this.tagBuffer.writeUI16(tag.getHeight());
        this.tagBuffer.writeUB(0, 4);
        this.tagBuffer.writeUB(tag.getDeblocking(), 3);
        this.tagBuffer.writeBit(tag.isSmoothing());
        this.tagBuffer.writeUI8(tag.getCodecID());
    }

    private void writeDefineButtonSound(DefineButtonSoundTag tag) {
        this.tagBuffer.writeUI16(tag.getButtonTag().getCharacterID());
        for (int i = 0; i < 4; ++i) {
            if (tag.getSoundChar()[i] == null) {
                this.tagBuffer.writeUI16(0);
                continue;
            }
            assert (tag.getSoundChar()[i].getTagType() == TagType.DefineSound);
            this.tagBuffer.writeUI16(tag.getSoundChar()[i].getCharacterID());
            this.writeSoundInfo(tag.getSoundInfo()[i]);
        }
    }

    private void writeDefineButton2(DefineButton2Tag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUB(0, 7);
        this.tagBuffer.writeBit(tag.isTrackAsMenu());
        this.tagBuffer.writeUI16(tag.getActionOffset());
        for (ButtonRecord r : tag.getCharacters()) {
            this.writeButtonRecord(r, tag.getTagType());
        }
        this.tagBuffer.writeUI8(0);
        this.tagBuffer.write(tag.getActions());
    }

    private void writeDefineButton(DefineButtonTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        for (ButtonRecord record : tag.getCharacters()) {
            this.writeButtonRecord(record, tag.getTagType());
        }
        this.tagBuffer.writeUI8(0);
        this.tagBuffer.write(tag.getActions());
        this.tagBuffer.writeUI8(0);
    }

    private void writeButtonRecord(ButtonRecord record, TagType tagType) {
        this.tagBuffer.writeUB(0, 2);
        this.tagBuffer.writeBit(record.isHasBlendMode());
        this.tagBuffer.writeBit(record.isHasFilterList());
        this.tagBuffer.writeBit(record.isStateHitTest());
        this.tagBuffer.writeBit(record.isStateDown());
        this.tagBuffer.writeBit(record.isStateOver());
        this.tagBuffer.writeBit(record.isStateUp());
        this.tagBuffer.writeUI16(record.getCharacterID());
        this.tagBuffer.writeUI16(record.getPlaceDepth());
        this.writeMatrix(record.getPlaceMatrix());
        if (tagType == TagType.DefineButton2) {
            this.writeColorTransformWithAlpha(record.getColorTransform());
            if (record.isHasFilterList()) {
                this.tagBuffer.writeUI8(record.getFilterList().length);
                for (Filter filter : record.getFilterList()) {
                    this.writeFilter(filter);
                }
            }
            if (record.isHasBlendMode()) {
                this.tagBuffer.writeUI8(record.getBlendMode());
            }
        }
    }

    private void writeFilter(Filter filter) {
        this.tagBuffer.writeUI8(filter.getFilterID());
        switch (filter.getFilterID()) {
            case 0: {
                this.writeDropShadowFilter(filter.getDropShadowFilter());
                break;
            }
            case 1: {
                this.writeBlurFilter(filter.getBlurFilter());
                break;
            }
            case 2: {
                this.writeGlowFilter(filter.getGlowFilter());
                break;
            }
            case 3: {
                this.writeBevelFilter(filter.getBevelFilter());
                break;
            }
            case 4: {
                this.writeGradientGlowFilter(filter.getGradientGlowFilter());
                break;
            }
            case 5: {
                this.writeConvolutionFilter(filter.getConvolutionFilter());
                break;
            }
            case 6: {
                this.writeColorMatrixFilter(filter.getColorMatrixFilter());
                break;
            }
            case 7: {
                this.writeGradientBevelFilter(filter.getGradientBevelFilter());
            }
        }
    }

    private void writeGradientBevelFilter(GradientBevelFilter filter) {
        assert (filter.getNumColors() == filter.getGradientColors().length);
        assert (filter.getNumColors() == filter.getGradientRatio().length);
        this.tagBuffer.writeUI8(filter.getNumColors());
        for (RGBA color : filter.getGradientColors()) {
            this.writeRGBA(color);
        }
        for (int ratio : filter.getGradientRatio()) {
            this.tagBuffer.writeUI8(ratio);
        }
        this.tagBuffer.writeFIXED(filter.getBlurX());
        this.tagBuffer.writeFIXED(filter.getBlurY());
        this.tagBuffer.writeFIXED(filter.getAngle());
        this.tagBuffer.writeFIXED(filter.getDistance());
        this.tagBuffer.writeFIXED8(filter.getStrength());
        this.tagBuffer.writeBit(filter.isInnerShadow());
        this.tagBuffer.writeBit(filter.isKnockout());
        this.tagBuffer.writeBit(filter.isCompositeSource());
        this.tagBuffer.writeBit(filter.isOnTop());
        this.tagBuffer.writeUB(filter.getPasses(), 4);
    }

    private void writeGradientGlowFilter(GradientGlowFilter filter) {
        assert (filter.getNumColors() == filter.getGradientColors().length);
        assert (filter.getNumColors() == filter.getGradientRatio().length);
        this.tagBuffer.writeUI8(filter.getNumColors());
        for (RGBA color : filter.getGradientColors()) {
            this.writeRGBA(color);
        }
        for (int ratio : filter.getGradientRatio()) {
            this.tagBuffer.writeUI8(ratio);
        }
        this.tagBuffer.writeFIXED(filter.getBlurX());
        this.tagBuffer.writeFIXED(filter.getBlurY());
        this.tagBuffer.writeFIXED(filter.getAngle());
        this.tagBuffer.writeFIXED(filter.getDistance());
        this.tagBuffer.writeFIXED8(filter.getStrength());
        this.tagBuffer.writeBit(filter.isInnerGlow());
        this.tagBuffer.writeBit(filter.isKnockout());
        this.tagBuffer.writeBit(filter.isCompositeSource());
        this.tagBuffer.writeBit(filter.isOnTop());
        this.tagBuffer.writeUB(filter.getPasses(), 4);
    }

    private void writeBevelFilter(BevelFilter filter) {
        this.writeRGBA(filter.getHighlightColor());
        this.writeRGBA(filter.getShadowColor());
        this.tagBuffer.writeFIXED(filter.getBlurX());
        this.tagBuffer.writeFIXED(filter.getBlurY());
        this.tagBuffer.writeFIXED(filter.getAngle());
        this.tagBuffer.writeFIXED(filter.getDistance());
        this.tagBuffer.writeFIXED8(filter.getStrength());
        this.tagBuffer.writeBit(filter.isInnerShadow());
        this.tagBuffer.writeBit(filter.isKnockout());
        this.tagBuffer.writeBit(filter.isCompositeSource());
        this.tagBuffer.writeBit(filter.isOnTop());
        this.tagBuffer.writeUB(filter.getPasses(), 4);
    }

    private void writeGlowFilter(GlowFilter filter) {
        this.writeRGBA(filter.getGlowColor());
        this.tagBuffer.writeFIXED(filter.getBlurX());
        this.tagBuffer.writeFIXED(filter.getBlurY());
        this.tagBuffer.writeFIXED8(filter.getStrength());
        this.tagBuffer.writeBit(filter.isInnerGlow());
        this.tagBuffer.writeBit(filter.isKnockout());
        this.tagBuffer.writeBit(filter.isCompositeSource());
        this.tagBuffer.writeUB(filter.getPasses(), 5);
    }

    private void writeDropShadowFilter(DropShadowFilter filter) {
        this.writeRGBA(filter.getDropShadowColor());
        this.tagBuffer.writeFIXED(filter.getBlurX());
        this.tagBuffer.writeFIXED(filter.getBlurY());
        this.tagBuffer.writeFIXED(filter.getAngle());
        this.tagBuffer.writeFIXED(filter.getDistance());
        this.tagBuffer.writeFIXED8(filter.getStrength());
        this.tagBuffer.writeBit(filter.isInnerShadow());
        this.tagBuffer.writeBit(filter.isKnockout());
        this.tagBuffer.writeBit(filter.isCompositeSource());
        this.tagBuffer.writeUB(filter.getPasses(), 5);
    }

    private void writeBlurFilter(BlurFilter filter) {
        this.tagBuffer.writeFIXED(filter.getBlurX());
        this.tagBuffer.writeFIXED(filter.getBlurY());
        this.tagBuffer.writeUB(filter.getPasses(), 5);
        this.tagBuffer.writeUB(0, 3);
    }

    private void writeConvolutionFilter(ConvolutionFilter filter) {
        assert (filter.getMatrixX() * filter.getMatrixY() == filter.getMatrix().length);
        this.tagBuffer.writeUI8(filter.getMatrixX());
        this.tagBuffer.writeUI8(filter.getMatrixY());
        this.tagBuffer.writeFLOAT(filter.getDivisor());
        this.tagBuffer.writeFLOAT(filter.getBias());
        for (float f : filter.getMatrix()) {
            this.tagBuffer.writeFLOAT(f);
        }
        this.writeRGBA(filter.getDefaultColor());
        this.tagBuffer.writeUB(0, 6);
        this.tagBuffer.writeBit(filter.isClamp());
        this.tagBuffer.writeBit(filter.isPreserveAlpha());
        this.tagBuffer.byteAlign();
    }

    private void writeColorMatrixFilter(float[] filter) {
        assert (filter.length == 20);
        for (float f : filter) {
            this.tagBuffer.writeFLOAT(f);
        }
    }

    private void writeColorTransformWithAlpha(CXFormWithAlpha cx) {
        int nbits = SWFWriter.requireSBCount(cx.getRedMultTerm(), cx.getGreenMultTerm(), cx.getBlueMultTerm(), cx.getAlphaMultTerm(), cx.getRedAddTerm(), cx.getGreenAddTerm(), cx.getBlueAddTerm(), cx.getAlphaAddTerm());
        this.tagBuffer.writeBit(cx.hasAdd());
        this.tagBuffer.writeBit(cx.hasMult());
        this.tagBuffer.writeUB(nbits, 4);
        if (cx.hasMult()) {
            this.tagBuffer.writeSB(cx.getRedMultTerm(), nbits);
            this.tagBuffer.writeSB(cx.getGreenMultTerm(), nbits);
            this.tagBuffer.writeSB(cx.getBlueMultTerm(), nbits);
            this.tagBuffer.writeSB(cx.getAlphaMultTerm(), nbits);
        }
        if (cx.hasAdd()) {
            this.tagBuffer.writeSB(cx.getRedAddTerm(), nbits);
            this.tagBuffer.writeSB(cx.getGreenAddTerm(), nbits);
            this.tagBuffer.writeSB(cx.getBlueAddTerm(), nbits);
            this.tagBuffer.writeSB(cx.getAlphaAddTerm(), nbits);
        }
        this.tagBuffer.byteAlign();
    }

    private void writeSoundStreamBlock(SoundStreamBlockTag tag) {
        this.tagBuffer.write(tag.getStreamSoundData());
    }

    private void writeSoundStreamHead(SoundStreamHeadTag tag) {
        this.tagBuffer.byteAlign();
        this.tagBuffer.writeUB(0, 4);
        this.tagBuffer.writeUB(tag.getPlaybackSoundRate(), 2);
        this.tagBuffer.writeUB(tag.getPlaybackSoundSize(), 1);
        this.tagBuffer.writeUB(tag.getPlaybackSoundType(), 1);
        this.tagBuffer.writeUB(tag.getStreamSoundCompression(), 4);
        this.tagBuffer.writeUB(tag.getStreamSoundRate(), 2);
        this.tagBuffer.writeUB(tag.getStreamSoundSize(), 1);
        this.tagBuffer.writeUB(tag.getStreamSoundType(), 1);
        this.tagBuffer.writeUI16(tag.getStreamSoundSampleCount());
        if (tag.getStreamSoundCompression() == 2) {
            this.tagBuffer.writeSI16(tag.getLatencySeek());
        }
    }

    private void writeStartSound2(StartSound2Tag tag) {
        this.tagBuffer.writeString(tag.getSoundClassName());
        this.writeSoundInfo(tag.getSoundInfo());
    }

    private void writeStartSound(StartSoundTag tag) {
        this.tagBuffer.writeUI16(tag.getSoundTag().getCharacterID());
        this.writeSoundInfo(tag.getSoundInfo());
    }

    private void writeSoundInfo(SoundInfo soundInfo) {
        this.tagBuffer.byteAlign();
        this.tagBuffer.writeUB(0, 2);
        this.tagBuffer.writeBit(soundInfo.isSyncStop());
        this.tagBuffer.writeBit(soundInfo.isSyncNoMultiple());
        this.tagBuffer.writeBit(soundInfo.isHasEnvelope());
        this.tagBuffer.writeBit(soundInfo.isHasLoops());
        this.tagBuffer.writeBit(soundInfo.isHasOutPoint());
        this.tagBuffer.writeBit(soundInfo.isHasInPoint());
        if (soundInfo.isHasInPoint()) {
            this.tagBuffer.writeUI32(soundInfo.getInPoint());
        }
        if (soundInfo.isHasOutPoint()) {
            this.tagBuffer.writeUI32(soundInfo.getOutPoint());
        }
        if (soundInfo.isHasLoops()) {
            this.tagBuffer.writeUI16(soundInfo.getLoopCount());
        }
        if (soundInfo.isHasEnvelope()) {
            this.tagBuffer.writeUI8(soundInfo.getEnvPoints());
            for (SoundEnvelope env : soundInfo.getEnvelopeRecords()) {
                this.tagBuffer.writeUI32(env.getPos44());
                this.tagBuffer.writeUI16(env.getLeftLevel());
                this.tagBuffer.writeUI16(env.getRightLevel());
            }
        }
    }

    private void writeDefineSound(DefineSoundTag tag) {
        this.tagBuffer.byteAlign();
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUB(tag.getSoundFormat(), 4);
        this.tagBuffer.writeUB(tag.getSoundRate(), 2);
        this.tagBuffer.writeUB(tag.getSoundSize(), 1);
        this.tagBuffer.writeUB(tag.getSoundType(), 1);
        this.tagBuffer.writeUI32(tag.getSoundSampleCount());
        this.tagBuffer.write(tag.getSoundData());
    }

    private void writeDefineFont4(DefineFont4Tag tag, Collection<ITag> extraTags) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUB(0, 5);
        this.tagBuffer.writeBit(tag.isFontFlagsHasFontData());
        this.tagBuffer.writeBit(tag.isFontFlagsItalic());
        this.tagBuffer.writeBit(tag.isFontFlagsBold());
        this.tagBuffer.writeString(tag.getFontName());
        this.tagBuffer.write(tag.getFontData());
        DefineFontNameTag license = tag.getLicense();
        if (license != null) {
            extraTags.add(license);
        }
    }

    private void writeCSMTextSettings(CSMTextSettingsTag tag) {
        this.tagBuffer.writeUI16(tag.getTextTag().getCharacterID());
        this.tagBuffer.writeUB(tag.getUseFlashType(), 2);
        this.tagBuffer.writeUB(tag.getGridFit(), 3);
        this.tagBuffer.writeUB(0, 3);
        this.tagBuffer.writeFLOAT(tag.getThickness());
        this.tagBuffer.writeFLOAT(tag.getSharpness());
        this.tagBuffer.writeUI8(0);
    }

    private void writeDefineEditText(DefineEditTextTag tag, Collection<ITag> extraTags) {
        CSMTextSettingsTag textSettings;
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.writeRect(tag.getBounds());
        this.tagBuffer.writeBit(tag.isHasText());
        this.tagBuffer.writeBit(tag.isWordWrap());
        this.tagBuffer.writeBit(tag.isMultiline());
        this.tagBuffer.writeBit(tag.isPassword());
        this.tagBuffer.writeBit(tag.isReadOnly());
        this.tagBuffer.writeBit(tag.isHasTextColor());
        this.tagBuffer.writeBit(tag.isHasMaxLength());
        this.tagBuffer.writeBit(tag.isHasFont());
        this.tagBuffer.writeBit(tag.isHasFontClass());
        this.tagBuffer.writeBit(tag.isAutoSize());
        this.tagBuffer.writeBit(tag.isHasLayout());
        this.tagBuffer.writeBit(tag.isNoSelect());
        this.tagBuffer.writeBit(tag.isBorder());
        this.tagBuffer.writeBit(tag.isWasStatic());
        this.tagBuffer.writeBit(tag.isHtml());
        this.tagBuffer.writeBit(tag.isUseOutlines());
        if (tag.isHasFont()) {
            this.tagBuffer.writeUI16(tag.getFontTag().getCharacterID());
            this.tagBuffer.writeUI16(tag.getFontHeight());
        } else if (tag.isHasFontClass()) {
            this.tagBuffer.writeString(tag.getFontClass());
            this.tagBuffer.writeUI16(tag.getFontHeight());
        }
        if (tag.isHasTextColor()) {
            this.writeRGBA(tag.getTextColor());
        }
        if (tag.isHasMaxLength()) {
            this.tagBuffer.writeUI16(tag.getMaxLength());
        }
        if (tag.isHasLayout()) {
            this.tagBuffer.writeUI8(tag.getAlign());
            this.tagBuffer.writeUI16(tag.getLeftMargin());
            this.tagBuffer.writeUI16(tag.getRightMargin());
            this.tagBuffer.writeUI16(tag.getIndent());
            this.tagBuffer.writeSI16(tag.getLeading());
        }
        this.tagBuffer.writeString(tag.getVariableName());
        if (tag.isHasText()) {
            this.tagBuffer.writeString(tag.getInitialText());
        }
        if ((textSettings = tag.getCSMTextSettings()) != null) {
            extraTags.add(textSettings);
        }
    }

    private void writeDefineText2(DefineText2Tag tag, Collection<ITag> extraTags) {
        this.writeDefineText(tag, extraTags);
    }

    private void writeDefineText(DefineTextTag tag, Collection<ITag> extraTags) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.writeRect(tag.getTextBounds());
        this.writeMatrix(tag.getTextMatrix());
        this.tagBuffer.writeUI8(tag.getGlyphBits());
        this.tagBuffer.writeUI8(tag.getAdvanceBits());
        for (TextRecord textRecord : tag.getTextRecords()) {
            this.writeTextRecord(textRecord, tag);
        }
        this.tagBuffer.byteAlign();
        this.tagBuffer.writeUI8(0);
        CSMTextSettingsTag textSettings = tag.getCSMTextSettings();
        if (textSettings != null) {
            extraTags.add(textSettings);
        }
    }

    private void writeTextRecord(TextRecord textRecord, DefineTextTag tag) {
        this.tagBuffer.byteAlign();
        this.tagBuffer.writeBit(true);
        this.tagBuffer.writeUB(0, 3);
        this.tagBuffer.writeBit(textRecord.isStyleFlagsHasFont());
        this.tagBuffer.writeBit(textRecord.isStyleFlagsHasColor());
        this.tagBuffer.writeBit(textRecord.isStyleFlagsHasYOffset());
        this.tagBuffer.writeBit(textRecord.isStyleFlagsHasXOffset());
        if (textRecord.isStyleFlagsHasFont()) {
            this.tagBuffer.writeUI16(textRecord.getFontTag().getCharacterID());
        }
        if (textRecord.isStyleFlagsHasColor()) {
            if (tag.getTagType() == TagType.DefineText2) {
                assert (textRecord.getTextColor() instanceof RGBA);
                this.writeRGBA((RGBA)textRecord.getTextColor());
            } else {
                this.writeRGB(textRecord.getTextColor());
            }
        }
        if (textRecord.isStyleFlagsHasXOffset()) {
            this.tagBuffer.writeSI16(textRecord.getxOffset());
        }
        if (textRecord.isStyleFlagsHasYOffset()) {
            this.tagBuffer.writeSI16(textRecord.getyOffset());
        }
        if (textRecord.isStyleFlagsHasFont()) {
            this.tagBuffer.writeUI16(textRecord.getTextHeight());
        }
        this.tagBuffer.writeUI8(textRecord.getGlyphCount());
        assert (textRecord.getGlyphCount() == textRecord.getGlyphEntries().length);
        for (GlyphEntry entry : textRecord.getGlyphEntries()) {
            this.writeGlyphEntry(entry, tag);
        }
    }

    private void writeGlyphEntry(GlyphEntry entry, DefineTextTag tag) {
        this.tagBuffer.writeUB(entry.getGlyphIndex(), tag.getGlyphBits());
        this.tagBuffer.writeSB(entry.getGlyphAdvance(), tag.getAdvanceBits());
    }

    private void writeDefineFontName(DefineFontNameTag tag) {
        this.tagBuffer.writeUI16(tag.getFontTag().getCharacterID());
        this.tagBuffer.writeString(tag.getFontName());
        this.tagBuffer.writeString(tag.getFontCopyright());
    }

    private void writeDefineFontAlignZones(DefineFontAlignZonesTag tag) {
        this.tagBuffer.writeUI16(tag.getFontTag().getCharacterID());
        this.tagBuffer.writeUB(tag.getCsmTableHint(), 2);
        this.tagBuffer.writeUB(0, 6);
        this.tagBuffer.byteAlign();
        for (ZoneRecord zoneRecord : tag.getZoneTable()) {
            this.writeZoneRecord(zoneRecord);
        }
    }

    private void writeZoneRecord(ZoneRecord zoneRecord) {
        assert (zoneRecord.getNumZoneData() == 2);
        this.tagBuffer.writeUI8(2);
        this.tagBuffer.writeUI32(zoneRecord.getZoneData0().getData());
        this.tagBuffer.writeUI32(zoneRecord.getZoneData1().getData());
        this.tagBuffer.writeUB(0, 6);
        this.tagBuffer.writeBit(zoneRecord.isZoneMaskY());
        this.tagBuffer.writeBit(zoneRecord.isZoneMaskX());
    }

    private void writeDefineFont3(DefineFont3Tag tag, Collection<ITag> extraTags) {
        DefineFontAlignZonesTag zones = tag.getZones();
        if (zones != null) {
            extraTags.add(zones);
        }
        this.writeDefineFont2(tag, extraTags);
    }

    private void writeDefineFont2(DefineFont2Tag tag, Collection<ITag> extraTags) {
        DefineFontNameTag defineFontNameTag;
        int numGlyphs = tag.getNumGlyphs();
        int[] shapeSizes = new int[numGlyphs];
        IOutputBitStream shapeBuffer = this.writeGlyphTableToBuffer(numGlyphs, tag, shapeSizes);
        if (!tag.isFontFlagsWideOffsets() && shapeBuffer.size() > 65535) {
            tag.setFontFlagsWideOffsets(true);
        }
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeBit(tag.isFontFlagsHasLayout());
        this.tagBuffer.writeBit(tag.isFontFlagsShiftJIS());
        this.tagBuffer.writeBit(tag.isFontFlagsSmallText());
        this.tagBuffer.writeBit(tag.isFontFlagsANSI());
        this.tagBuffer.writeBit(tag.isFontFlagsWideOffsets());
        this.tagBuffer.writeBit(tag.isFontFlagsWideCodes());
        this.tagBuffer.writeBit(tag.isFontFlagsItalic());
        this.tagBuffer.writeBit(tag.isFontFlagsBold());
        this.tagBuffer.writeUI8(tag.getLanguageCode());
        this.writeLengthString(tag.getFontName());
        this.tagBuffer.writeUI16(numGlyphs);
        this.writeFontOffsetAndGlyphTable(shapeBuffer, shapeSizes, numGlyphs, tag.getTagType(), tag.isFontFlagsWideOffsets());
        assert (tag.getCodeTable().length == tag.getNumGlyphs());
        for (int code : tag.getCodeTable()) {
            if (tag.isFontFlagsWideCodes()) {
                this.tagBuffer.writeUI16(code);
                continue;
            }
            this.tagBuffer.writeUI8(code);
        }
        if (tag.isFontFlagsHasLayout()) {
            assert (tag.getFontAdvanceTable().length == tag.getNumGlyphs());
            this.tagBuffer.writeSI16(tag.getFontAscent());
            this.tagBuffer.writeSI16(tag.getFontDescent());
            this.tagBuffer.writeSI16(tag.getFontLeading());
            for (int fontAdvance : tag.getFontAdvanceTable()) {
                this.tagBuffer.writeSI16(fontAdvance);
            }
            assert (tag.getFontBoundsTable().length == tag.getNumGlyphs());
            for (Rect bound : tag.getFontBoundsTable()) {
                this.writeRect(bound);
            }
            this.tagBuffer.writeUI16(tag.getKerningCount());
            assert (tag.getKerningCount() == tag.getFontKerningTable().length);
            for (KerningRecord kerning : tag.getFontKerningTable()) {
                this.writeKerningRecord(kerning, tag.isFontFlagsWideCodes());
            }
        }
        if ((defineFontNameTag = tag.getLicense()) != null) {
            extraTags.add(defineFontNameTag);
        }
    }

    private void writeKerningRecord(KerningRecord kerning, boolean fontFlagsWideCodes) {
        if (fontFlagsWideCodes) {
            this.tagBuffer.writeUI16(kerning.getCode1());
            this.tagBuffer.writeUI16(kerning.getCode2());
        } else {
            this.tagBuffer.writeUI32(kerning.getCode1());
            this.tagBuffer.writeUI32(kerning.getCode2());
        }
        this.tagBuffer.writeSI16(kerning.getAdjustment());
    }

    private void writeDefineFontInfo2(DefineFontInfo2Tag tag) {
        this.tagBuffer.writeUI16(tag.getFontTag().getCharacterID());
        this.writeLengthString(tag.getFontName());
        this.tagBuffer.writeUB(tag.getFontFlagsReserved(), 2);
        this.tagBuffer.writeBit(tag.isFontFlagsSmallText());
        this.tagBuffer.writeBit(tag.isFontFlagsShiftJIS());
        this.tagBuffer.writeBit(tag.isFontFlagsANSI());
        this.tagBuffer.writeBit(tag.isFontFlagsItalic());
        this.tagBuffer.writeBit(tag.isFontFlagsBold());
        this.tagBuffer.writeBit(tag.isFontFlagsWideCodes());
        this.tagBuffer.writeUI8(tag.getLanguageCode());
        for (int code : tag.getCodeTable()) {
            if (tag.isFontFlagsWideCodes()) {
                this.tagBuffer.writeUI16(code);
                continue;
            }
            this.tagBuffer.writeUI8(code);
        }
    }

    private void writeDefineFontInfo(IFontInfo tag) {
        this.tagBuffer.writeUI16(tag.getFontTag().getCharacterID());
        this.writeLengthString(tag.getFontName());
        this.tagBuffer.writeUB(tag.getFontFlagsReserved(), 2);
        this.tagBuffer.writeBit(tag.isFontFlagsSmallText());
        this.tagBuffer.writeBit(tag.isFontFlagsShiftJIS());
        this.tagBuffer.writeBit(tag.isFontFlagsANSI());
        this.tagBuffer.writeBit(tag.isFontFlagsItalic());
        this.tagBuffer.writeBit(tag.isFontFlagsBold());
        this.tagBuffer.writeBit(tag.isFontFlagsWideCodes());
        for (int code : tag.getCodeTable()) {
            if (tag.isFontFlagsWideCodes()) {
                this.tagBuffer.writeUI16(code);
                continue;
            }
            this.tagBuffer.writeUI8(code);
        }
    }

    private IOutputBitStream writeGlyphTableToBuffer(int numGlyphs, DefineFontTag tag, int[] shapeSizes) {
        IOutputBitStream currentTagBuffer = this.tagBuffer;
        OutputBitStream shapeBuffer = new OutputBitStream();
        this.tagBuffer = shapeBuffer;
        int currentOffset = 0;
        int previousOffset = 0;
        Shape[] shapes = tag.getGlyphShapeTable();
        for (int i = 0; i < numGlyphs; ++i) {
            this.writeShape(shapes[i], tag.getTagType(), 1, 0);
            currentOffset = shapeBuffer.size();
            shapeSizes[i] = currentOffset - previousOffset;
            previousOffset = currentOffset;
        }
        this.tagBuffer = currentTagBuffer;
        return shapeBuffer;
    }

    private void writeFontOffsetAndGlyphTable(IOutputBitStream shapeBuffer, int[] shapeSizes, int numGlyphs, TagType tagType, boolean wideOffsets) {
        int offsetTableElementSize = wideOffsets ? 4 : 2;
        int baseOffset = numGlyphs * offsetTableElementSize;
        if (tagType != TagType.DefineFont) {
            baseOffset = wideOffsets ? (baseOffset += 4) : (baseOffset += 2);
        }
        int currentOffset = baseOffset;
        for (int i = 0; i < numGlyphs; ++i) {
            if (wideOffsets) {
                this.tagBuffer.writeUI32(currentOffset);
            } else {
                this.tagBuffer.writeUI16(currentOffset);
            }
            currentOffset += shapeSizes[i];
        }
        if (tagType != TagType.DefineFont && numGlyphs > 0) {
            assert (currentOffset == baseOffset + shapeBuffer.size()) : "offset mismatch writing font glyph table";
            if (wideOffsets) {
                this.tagBuffer.writeUI32(currentOffset);
            } else {
                this.tagBuffer.writeUI16(currentOffset);
            }
        }
        this.tagBuffer.write(shapeBuffer.getBytes(), 0, shapeBuffer.size());
        try {
            shapeBuffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDefineFont(DefineFontTag tag, Collection<ITag> extraTags) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        int numGlyphs = tag.getGlyphShapeTable().length;
        int[] shapeSizes = new int[numGlyphs];
        IOutputBitStream shapeBuffer = this.writeGlyphTableToBuffer(numGlyphs, tag, shapeSizes);
        this.writeFontOffsetAndGlyphTable(shapeBuffer, shapeSizes, numGlyphs, tag.getTagType(), false);
        DefineFontNameTag license = tag.getLicense();
        if (license != null) {
            extraTags.add(license);
        }
    }

    private void writeDefineBitsJPEG3(DefineBitsJPEG3Tag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUI32(tag.getAlphaDataOffset());
        this.tagBuffer.write(tag.getImageData());
        this.tagBuffer.write(tag.getBitmapAlphaData());
    }

    private void writeDefineBitsJPEG2(DefineBitsJPEG2Tag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.write(tag.getImageData());
    }

    private void writeJPEGTables(JPEGTablesTag tag) {
        this.tagBuffer.write(tag.getJpegData());
    }

    private void writeDefineBits(DefineBitsTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.write(tag.getImageData());
    }

    private void writeDefineScalingGrid(DefineScalingGridTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacter().getCharacterID());
        this.writeRect(tag.getSplitter());
    }

    private void writeExportAssets(ExportAssetsTag tag) {
        this.tagBuffer.writeUI16(tag.size());
        for (String name : tag.getCharacterNames()) {
            ICharacterTag characterTag = tag.getCharacterTagByName(name);
            this.tagBuffer.writeUI16(characterTag.getCharacterID());
            this.tagBuffer.writeString(name);
        }
    }

    protected void writeDefineSprite(DefineSpriteTag tag) {
        this.tagBuffer.writeUI16(tag.getCharacterID());
        this.tagBuffer.writeUI16(tag.getFrameCount());
        OutputBitStream controlTagBuffer = new OutputBitStream();
        for (ITag controlTag : tag.getControlTags()) {
            controlTagBuffer.reset();
            this.writeTag(controlTag, controlTagBuffer, this.tagBuffer);
        }
        this.tagBuffer.writeUI16(0);
    }

    @Override
    public void writeTo(OutputStream output) {
        ScriptLimitsTag scriptLimitsTag;
        ProductInfoTag productInfo;
        RGB backgroundColor;
        assert (output != null);
        this.writtenTags = new HashSet<ITag>();
        this.writeCompressibleHeader();
        this.writeTag(SWF.getFileAttributes(this.swf));
        String metadata = this.swf.getMetadata();
        if (metadata != null) {
            this.writeTag(new MetadataTag(metadata));
        }
        if ((backgroundColor = this.swf.getBackgroundColor()) != null) {
            this.writeTag(new SetBackgroundColorTag(backgroundColor));
        }
        if (this.enableDebug) {
            this.writeTag(new EnableDebugger2Tag("NO-PASSWORD"));
        }
        if (this.enableTelemetry) {
            this.writeTag(new EnableTelemetryTag());
        }
        if ((productInfo = this.swf.getProductInfo()) != null) {
            this.writeTag(productInfo);
        }
        if ((scriptLimitsTag = this.swf.getScriptLimits()) != null) {
            this.writeTag(scriptLimitsTag);
        }
        this.writeFrames();
        this.writeTag(new EndTag());
        this.writtenTags = null;
        long length = this.outputBuffer.size() + 8;
        try {
            switch (this.useCompression) {
                case LZMA: {
                    output.write(90);
                    break;
                }
                case ZLIB: {
                    output.write(67);
                    break;
                }
                case NONE: {
                    output.write(70);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            output.write(87);
            output.write(83);
            output.write(this.swf.getVersion());
            this.writeInt(output, (int)length);
            switch (this.useCompression) {
                case LZMA: {
                    LZMACompressor compressor = new LZMACompressor();
                    compressor.compress(this.outputBuffer);
                    long compressedLength = compressor.getLengthOfCompressedPayload();
                    assert (compressedLength <= 0xFFFFFFFFL);
                    this.writeInt(output, (int)compressedLength);
                    compressor.writeLZMAProperties(output);
                    compressor.writeDataAndEnd(output);
                    output.flush();
                    break;
                }
                case ZLIB: {
                    int compressionLevel = this.enableDebug ? 1 : 9;
                    Deflater deflater = new Deflater(compressionLevel);
                    DeflaterOutputStream deflaterStream = new DeflaterOutputStream(output, deflater);
                    deflaterStream.write(this.outputBuffer.getBytes(), 0, this.outputBuffer.size());
                    deflaterStream.finish();
                    deflater.end();
                    deflaterStream.flush();
                    break;
                }
                case NONE: {
                    output.write(this.outputBuffer.getBytes(), 0, this.outputBuffer.size());
                    output.flush();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(OutputStream output, int theInt) throws IOException {
        output.write(theInt);
        output.write(theInt >> 8);
        output.write(theInt >> 16);
        output.write(theInt >> 24);
    }

    @Override
    public int writeTo(File outputFile) throws FileNotFoundException, IOException {
        File outputDirectory = new File(outputFile.getAbsoluteFile().getParent());
        outputDirectory.mkdirs();
        CountingOutputStream output = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)));
        this.writeTo((OutputStream)output);
        output.flush();
        output.close();
        this.close();
        int swfSize = output.getCount();
        return swfSize;
    }

    private void writeFrameLabel(FrameLabelTag tag) {
        this.tagBuffer.writeString(tag.getName());
    }

    @Override
    public void close() throws IOException {
        this.outputBuffer.close();
    }

    private static class SWFWriterFactory
    implements ISWFWriterFactory {
        private SWFWriterFactory() {
        }

        @Override
        public ISWFWriter createSWFWriter(ISWF swf, Header.Compression useCompression, boolean enableDebug, boolean enableTelemetry) {
            return new SWFWriter(swf, useCompression, enableDebug, enableTelemetry);
        }
    }
}

