/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.as;

import org.apache.flex.compiler.codegen.as.IASEmitter;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.visitor.IASNodeStrategy;

public class ASAfterNodeStrategy
implements IASNodeStrategy {
    private final IASEmitter emitter;

    public ASAfterNodeStrategy(IASEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void handle(IASNode node) {
        if (node.getNodeID() == ASTNodeID.BlockID) {
            IContainerNode container = (IContainerNode)node;
            IContainerNode.ContainerType type = container.getContainerType();
            if (type != IContainerNode.ContainerType.IMPLICIT && type != IContainerNode.ContainerType.SYNTHESIZED) {
                if (node.getChildCount() != 0) {
                    this.emitter.indentPop();
                    this.emitter.writeNewline();
                }
                this.emitter.emitBlockClose(container);
            } else if ((type == IContainerNode.ContainerType.IMPLICIT || type == IContainerNode.ContainerType.SYNTHESIZED) && node.getChildCount() != 0) {
                this.emitter.indentPop();
            }
        }
    }
}

