/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.codegen.CompilingClassLoader;
import com.google.common.truth.codegen.IteratingWrapperClassBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckReturnValue;

@GwtIncompatible(value="Code generation and loading.")
public class IteratingVerb<T> {
    private static final String CANNOT_WRAP_MSG = "Cannot build an iterating wrapper around ";
    private static LoadingCache<SubjectFactory<?, ?>, Class<?>> WRAPPER_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<SubjectFactory<?, ?>, Class<?>>(){

        public Class<?> load(SubjectFactory<?, ?> subjectFactory) throws Exception {
            return IteratingVerb.compileWrapperClass(subjectFactory);
        }
    });
    private final Iterable<T> data;
    private final FailureStrategy failureStrategy;

    public IteratingVerb(Iterable<T> data, FailureStrategy fs) {
        this.failureStrategy = fs;
        this.data = data;
    }

    @CheckReturnValue
    public <S extends Subject<S, T>, SF extends SubjectFactory<S, T>> S thatEach(SF factory) {
        return this.wrap(this.failureStrategy, factory, this.data);
    }

    private <S extends Subject<S, T>, SF extends SubjectFactory<S, T>> S wrap(FailureStrategy fs, SF factory, Iterable<T> data) {
        Class<S> t = factory.getSubjectClass();
        try {
            Class wrapperClass = (Class)WRAPPER_CACHE.get(factory);
            return (S)((Subject)this.instantiate(wrapperClass, t, fs, factory, data));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
    }

    private <SF, S> S instantiate(Class<?> wrapperType, Type t, FailureStrategy fs, SF factory, Iterable<T> data) {
        try {
            Constructor<?> c = wrapperType.getConstructors()[0];
            return (S)c.newInstance(fs, factory, data);
        }
        catch (SecurityException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
    }

    private static Class<?> compileWrapperClass(SubjectFactory<?, ?> subjectFactory) {
        CompilingClassLoader classLoader;
        IteratingWrapperClassBuilder builder = new IteratingWrapperClassBuilder(subjectFactory);
        String out = builder.build().toString();
        try {
            classLoader = new CompilingClassLoader(subjectFactory.getSubjectClass().getClassLoader(), builder.className, out, null);
        }
        catch (CompilingClassLoader.CompilerException e) {
            throw new Error("Could not compile class " + builder.className + " with source:\n" + out, e);
        }
        try {
            Class<?> wrapper = classLoader.loadClass(builder.className);
            return wrapper;
        }
        catch (ClassNotFoundException e) {
            throw new Error("Could not load class " + subjectFactory.getSubjectClass().getSimpleName(), e);
        }
    }
}

