/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan;

import org.apache.flink.agents.plan.Function;
import pemja.core.PythonInterpreter;

public class PythonFunction
implements Function {
    private static final String CALL_PYTHON_FUNCTION = "function.call_python_function";
    private final String module;
    private final String qualName;
    private transient PythonInterpreter interpreter;

    public PythonFunction(String module, String qualName) {
        this.module = module;
        this.qualName = qualName;
    }

    public void setInterpreter(PythonInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public Object call(Object ... args) throws Exception {
        if (this.interpreter == null) {
            throw new IllegalStateException("Python interpreter is not set.");
        }
        return this.interpreter.invoke(CALL_PYTHON_FUNCTION, new Object[]{this.module, this.qualName, args});
    }

    @Override
    public void checkSignature(Class<?>[] parameterTypes) throws Exception {
    }

    public String getModule() {
        return this.module;
    }

    public String getQualName() {
        return this.qualName;
    }
}

