/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.agents.plan.Function;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.PythonFunction;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.NullNode;

public class ActionJsonDeserializer
extends StdDeserializer<Action> {
    public ActionJsonDeserializer() {
        super(Action.class);
    }

    @Override
    public Action deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Function func;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String name = node.get("name").asText();
        JsonNode execNode = node.get("exec");
        String funcType = execNode.get("func_type").asText();
        if (JavaFunction.class.getSimpleName().equals(funcType)) {
            func = this.deserializeJavaFunction(execNode);
        } else if (PythonFunction.class.getSimpleName().equals(funcType)) {
            func = this.deserializePythonFunction(execNode);
        } else {
            throw new IOException("Unsupported function type: " + funcType);
        }
        ArrayList<String> listenEventTypes = new ArrayList<String>();
        node.get("listen_event_types").forEach(eventTypeNode -> listenEventTypes.add(eventTypeNode.asText()));
        Map config = null;
        JsonNode configNode = node.get("config");
        if (configNode != null && !(configNode instanceof NullNode)) {
            String configType = configNode.get("__config_type__").asText();
            if (configType.equals("java")) {
                try {
                    config = this.deserializeJavaConfig(node);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (configType.equals("python")) {
                config = (Map)this.deserializePythonConfig(configNode);
            }
        }
        try {
            return new Action(name, func, listenEventTypes, config);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create Action with name \"%s\"", name), e);
        }
    }

    private PythonFunction deserializePythonFunction(JsonNode execNode) {
        String module = execNode.get("module").asText();
        String qualName = execNode.get("qualname").asText();
        return new PythonFunction(module, qualName);
    }

    private JavaFunction deserializeJavaFunction(JsonNode execNode) throws IOException {
        String qualName = execNode.get("qualname").asText();
        String methodName = execNode.get("method_name").asText();
        Class[] parameterTypes = new Class[execNode.get("parameter_types").size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                String parameterTypeName = execNode.get("parameter_types").get(i).asText();
                parameterTypes[i] = Class.forName(parameterTypeName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to deserialize parameter type", e);
            }
        }
        try {
            return new JavaFunction(qualName, methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to create JavaFunction with qualName \"%s\" and method name \"%s\"", qualName, methodName), e);
        }
    }

    private Map<String, Object> deserializeJavaConfig(JsonNode node) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode configNode = node.get("config");
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (configNode != null && configNode.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iterator = configNode.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                String key = entry.getKey();
                if (key.equals("__config_type__")) {
                    config.put(key, entry.getValue().asText());
                    continue;
                }
                JsonNode clazzAndValue = entry.getValue();
                String clazz = clazzAndValue.get("@class").asText();
                JsonNode value = clazzAndValue.get("value");
                config.put(key, mapper.treeToValue((TreeNode)value, Class.forName(clazz)));
            }
        }
        return config;
    }

    private Object deserializePythonConfig(JsonNode node) {
        if (node.isObject()) {
            HashMap map = new HashMap();
            node.fields().forEachRemaining(entry -> map.put((String)entry.getKey(), this.deserializePythonConfig((JsonNode)entry.getValue())));
            return map;
        }
        if (node.isArray()) {
            ArrayList list = new ArrayList();
            node.forEach(element -> list.add(this.deserializePythonConfig((JsonNode)element)));
            return list;
        }
        if (node.isValueNode()) {
            return node.asText();
        }
        throw new UnsupportedOperationException("Unsupported node type: " + String.valueOf((Object)node.getNodeType()));
    }
}

