/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.lookup;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.lookup.RocksDBState;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDBValueState
extends RocksDBState<RocksDBState.Reference> {
    public RocksDBValueState(RocksDB db, ColumnFamilyHandle columnFamily, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> valueSerializer, long lruCacheSize) {
        super(db, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    @Nullable
    public RowData get(RowData key) throws IOException {
        try {
            RocksDBState.Reference valueRef = this.get(this.wrap(this.serializeKey(key)));
            return valueRef.isPresent() ? this.deserializeValue(valueRef.bytes) : null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private RocksDBState.Reference get(RocksDBState.ByteArray keyBytes) throws RocksDBException {
        RocksDBState.Reference valueRef = (RocksDBState.Reference)this.cache.getIfPresent((Object)keyBytes);
        if (valueRef == null) {
            valueRef = this.ref(this.db.get(this.columnFamily, keyBytes.bytes));
            this.cache.put((Object)keyBytes, (Object)valueRef);
        }
        return valueRef;
    }

    public void put(RowData key, RowData value) throws IOException {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        try {
            byte[] keyBytes = this.serializeKey(key);
            byte[] valueBytes = this.serializeValue(value);
            this.db.put(this.columnFamily, this.writeOptions, keyBytes, valueBytes);
            this.cache.put((Object)this.wrap(keyBytes), (Object)this.ref(valueBytes));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public void delete(RowData key) throws IOException {
        try {
            byte[] keyBytes = this.serializeKey(key);
            RocksDBState.ByteArray keyByteArray = this.wrap(keyBytes);
            if (this.get(keyByteArray).isPresent()) {
                this.db.delete(this.columnFamily, this.writeOptions, keyBytes);
                this.cache.put((Object)keyByteArray, (Object)this.ref(null));
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private RowData deserializeValue(byte[] valueBytes) throws IOException {
        this.valueInputView.setBuffer(valueBytes);
        return (RowData)this.valueSerializer.deserialize((DataInputView)this.valueInputView);
    }

    private byte[] serializeValue(RowData value) throws IOException {
        this.valueOutputView.clear();
        this.valueSerializer.serialize((Object)value, (DataOutputView)this.valueOutputView);
        return this.valueOutputView.getCopyOfBuffer();
    }
}

