/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.apache.flink.connector.file.src.impl.FileRecords;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.MutableRecordAndPosition;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.table.source.TableRead;

public class FileStoreSourceSplitReader
implements SplitReader<RecordAndPosition<RowData>, FileStoreSourceSplit> {
    private final TableRead tableRead;
    private final Queue<FileStoreSourceSplit> splits;
    private final Pool<FileStoreRecordIterator> pool;
    @Nullable
    private RecordReader<RowData> currentReader;
    @Nullable
    private String currentSplitId;
    private long currentNumRead;
    private RecordReader.RecordIterator<RowData> currentFirstBatch;

    public FileStoreSourceSplitReader(TableRead tableRead) {
        this.tableRead = tableRead;
        this.splits = new LinkedList<FileStoreSourceSplit>();
        this.pool = new Pool(1);
        this.pool.add((Object)new FileStoreRecordIterator());
    }

    public RecordsWithSplitIds<RecordAndPosition<RowData>> fetch() throws IOException {
        RecordReader.RecordIterator<RowData> nextBatch;
        this.checkSplitOrStartNext();
        FileStoreRecordIterator iterator = this.pool();
        if (this.currentFirstBatch != null) {
            nextBatch = this.currentFirstBatch;
            this.currentFirstBatch = null;
        } else {
            nextBatch = this.currentReader.readBatch();
        }
        if (nextBatch == null) {
            this.pool.recycler().recycle((Object)iterator);
            return this.finishSplit();
        }
        return FileRecords.forRecords((String)this.currentSplitId, (BulkFormat.RecordIterator)iterator.replace(nextBatch));
    }

    private FileStoreRecordIterator pool() throws IOException {
        try {
            return (FileStoreRecordIterator)this.pool.pollEntry();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted");
        }
    }

    public void handleSplitsChanges(SplitsChange<FileStoreSourceSplit> splitsChange) {
        if (!(splitsChange instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChange.getClass()));
        }
        this.splits.addAll(splitsChange.splits());
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    private void checkSplitOrStartNext() throws IOException {
        if (this.currentReader != null) {
            return;
        }
        FileStoreSourceSplit nextSplit = this.splits.poll();
        if (nextSplit == null) {
            throw new IOException("Cannot fetch from another split - no split remaining");
        }
        this.currentSplitId = nextSplit.splitId();
        this.currentReader = this.tableRead.createReader(nextSplit.split());
        this.currentNumRead = nextSplit.recordsToSkip();
        if (this.currentNumRead > 0L) {
            this.seek(this.currentNumRead);
        }
    }

    private void seek(long toSkip) throws IOException {
        while (true) {
            RecordReader.RecordIterator<RowData> nextBatch;
            if ((nextBatch = this.currentReader.readBatch()) == null) {
                throw new RuntimeException(String.format("skip(%s) more than the number of remaining elements.", toSkip));
            }
            while (toSkip > 0L && nextBatch.next() != null) {
                --toSkip;
            }
            if (toSkip == 0L) {
                this.currentFirstBatch = nextBatch;
                return;
            }
            nextBatch.releaseBatch();
        }
    }

    private FileRecords<RowData> finishSplit() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
            this.currentReader = null;
        }
        FileRecords finishRecords = FileRecords.finishedSplit((String)this.currentSplitId);
        this.currentSplitId = null;
        return finishRecords;
    }

    private class FileStoreRecordIterator
    implements BulkFormat.RecordIterator<RowData> {
        private RecordReader.RecordIterator<RowData> iterator;
        private final MutableRecordAndPosition<RowData> recordAndPosition = new MutableRecordAndPosition();

        private FileStoreRecordIterator() {
        }

        public FileStoreRecordIterator replace(RecordReader.RecordIterator<RowData> iterator) {
            this.iterator = iterator;
            this.recordAndPosition.set(null, -1L, FileStoreSourceSplitReader.this.currentNumRead);
            return this;
        }

        @Nullable
        public RecordAndPosition<RowData> next() {
            RowData row;
            try {
                row = this.iterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (row == null) {
                return null;
            }
            this.recordAndPosition.setNext((Object)row);
            FileStoreSourceSplitReader.this.currentNumRead++;
            return this.recordAndPosition;
        }

        public void releaseBatch() {
            this.iterator.releaseBatch();
            FileStoreSourceSplitReader.this.pool.recycler().recycle((Object)this);
        }
    }
}

