/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryRowDataUtil;
import org.apache.flink.table.store.file.stats.BinaryTableStats;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class DataFileMeta {
    public static final BinaryTableStats EMPTY_KEY_STATS = new BinaryTableStats(BinaryRowDataUtil.EMPTY_ROW, BinaryRowDataUtil.EMPTY_ROW, new long[0]);
    public static final BinaryRowData EMPTY_MIN_KEY = BinaryRowDataUtil.EMPTY_ROW;
    public static final BinaryRowData EMPTY_MAX_KEY = BinaryRowDataUtil.EMPTY_ROW;
    public static final int DUMMY_LEVEL = 0;
    private final String fileName;
    private final long fileSize;
    private final long rowCount;
    private final BinaryRowData minKey;
    private final BinaryRowData maxKey;
    private final BinaryTableStats keyStats;
    private final BinaryTableStats valueStats;
    private final long minSequenceNumber;
    private final long maxSequenceNumber;
    private final long schemaId;
    private final int level;
    private final List<String> extraFiles;

    public static DataFileMeta forAppend(String fileName, long fileSize, long rowCount, BinaryTableStats rowStats, long minSequenceNumber, long maxSequenceNumber, long schemaId) {
        return new DataFileMeta(fileName, fileSize, rowCount, EMPTY_MIN_KEY, EMPTY_MAX_KEY, EMPTY_KEY_STATS, rowStats, minSequenceNumber, maxSequenceNumber, schemaId, 0);
    }

    public DataFileMeta(String fileName, long fileSize, long rowCount, BinaryRowData minKey, BinaryRowData maxKey, BinaryTableStats keyStats, BinaryTableStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level) {
        this(fileName, fileSize, rowCount, minKey, maxKey, keyStats, valueStats, minSequenceNumber, maxSequenceNumber, schemaId, level, Collections.emptyList());
    }

    public DataFileMeta(String fileName, long fileSize, long rowCount, BinaryRowData minKey, BinaryRowData maxKey, BinaryTableStats keyStats, BinaryTableStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, List<String> extraFiles) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.keyStats = keyStats;
        this.valueStats = valueStats;
        this.minSequenceNumber = minSequenceNumber;
        this.maxSequenceNumber = maxSequenceNumber;
        this.level = level;
        this.schemaId = schemaId;
        this.extraFiles = Collections.unmodifiableList(extraFiles);
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long rowCount() {
        return this.rowCount;
    }

    public BinaryRowData minKey() {
        return this.minKey;
    }

    public BinaryRowData maxKey() {
        return this.maxKey;
    }

    public BinaryTableStats keyStats() {
        return this.keyStats;
    }

    public BinaryTableStats valueStats() {
        return this.valueStats;
    }

    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    public long maxSequenceNumber() {
        return this.maxSequenceNumber;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public int level() {
        return this.level;
    }

    public List<String> extraFiles() {
        return this.extraFiles;
    }

    public DataFileMeta upgrade(int newLevel) {
        Preconditions.checkArgument((newLevel > this.level ? 1 : 0) != 0);
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, newLevel, this.extraFiles);
    }

    public DataFileMeta copy(List<String> newExtraFiles) {
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, newExtraFiles);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataFileMeta)) {
            return false;
        }
        DataFileMeta that = (DataFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.rowCount == that.rowCount && Objects.equals(this.minKey, that.minKey) && Objects.equals(this.maxKey, that.maxKey) && Objects.equals(this.keyStats, that.keyStats) && Objects.equals(this.valueStats, that.valueStats) && this.minSequenceNumber == that.minSequenceNumber && this.maxSequenceNumber == that.maxSequenceNumber && this.schemaId == that.schemaId && this.level == that.level && Objects.equals(this.extraFiles, that.extraFiles);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles);
    }

    public String toString() {
        return String.format("{%s, %d, %d, %s, %s, %s, %s, %d, %d, %d, %d, %s}", this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles);
    }

    public static RowType schema() {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fields.add(new RowType.RowField("_FILE_NAME", (LogicalType)SerializationUtils.newStringType(false)));
        fields.add(new RowType.RowField("_FILE_SIZE", (LogicalType)new BigIntType(false)));
        fields.add(new RowType.RowField("_ROW_COUNT", (LogicalType)new BigIntType(false)));
        fields.add(new RowType.RowField("_MIN_KEY", (LogicalType)SerializationUtils.newBytesType(false)));
        fields.add(new RowType.RowField("_MAX_KEY", (LogicalType)SerializationUtils.newBytesType(false)));
        fields.add(new RowType.RowField("_KEY_STATS", (LogicalType)FieldStatsArraySerializer.schema()));
        fields.add(new RowType.RowField("_VALUE_STATS", (LogicalType)FieldStatsArraySerializer.schema()));
        fields.add(new RowType.RowField("_MIN_SEQUENCE_NUMBER", (LogicalType)new BigIntType(false)));
        fields.add(new RowType.RowField("_MAX_SEQUENCE_NUMBER", (LogicalType)new BigIntType(false)));
        fields.add(new RowType.RowField("_SCHEMA_ID", (LogicalType)new BigIntType(false)));
        fields.add(new RowType.RowField("_LEVEL", (LogicalType)new IntType(false)));
        fields.add(new RowType.RowField("_EXTRA_FILES", (LogicalType)new ArrayType(false, (LogicalType)SerializationUtils.newStringType(false))));
        return new RowType(fields);
    }
}

