/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.utils;

import java.util.function.Supplier;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.errors.TimeoutException;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.Time;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.Utils;

public class SystemTime
implements Time {
    @Override
    public long milliseconds() {
        return System.currentTimeMillis();
    }

    @Override
    public long nanoseconds() {
        return System.nanoTime();
    }

    @Override
    public void sleep(long ms) {
        Utils.sleep(ms);
    }

    @Override
    public void waitObject(Object obj, Supplier<Boolean> condition, long deadlineMs) throws InterruptedException {
        Object object = obj;
        synchronized (object) {
            while (true) {
                if (condition.get().booleanValue()) {
                    return;
                }
                long currentTimeMs = this.milliseconds();
                if (currentTimeMs >= deadlineMs) {
                    throw new TimeoutException("Condition not satisfied before deadline");
                }
                obj.wait(deadlineMs - currentTimeMs);
            }
        }
    }
}

