/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.memory.HeapMemorySegmentPool;
import org.apache.flink.table.store.file.memory.MemoryOwner;
import org.apache.flink.table.store.file.memory.MemoryPoolFactory;
import org.apache.flink.table.store.file.operation.FileStoreWrite;
import org.apache.flink.table.store.file.writer.RecordWriter;
import org.apache.flink.table.store.table.sink.AbstractTableWrite;
import org.apache.flink.table.store.table.sink.SinkRecordConverter;

public abstract class MemoryTableWrite<T>
extends AbstractTableWrite<T> {
    private final MemoryPoolFactory memoryPoolFactory;

    protected MemoryTableWrite(FileStoreWrite<T> write, SinkRecordConverter recordConverter, CoreOptions options) {
        super(write, recordConverter);
        HeapMemorySegmentPool memoryPool = new HeapMemorySegmentPool(options.writeBufferSize(), options.pageSize());
        this.memoryPoolFactory = new MemoryPoolFactory(memoryPool, this::memoryOwners);
    }

    private Iterator<MemoryOwner> memoryOwners() {
        final Iterator iterator = this.writers.values().iterator();
        return Iterators.concat((Iterator)new Iterator<Iterator<MemoryOwner>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Iterator<MemoryOwner> next() {
                return Iterators.transform(((Map)iterator.next()).values().iterator(), writer -> (MemoryOwner)((Object)writer));
            }
        });
    }

    @Override
    protected void notifyNewWriter(RecordWriter<T> writer) {
        if (!(writer instanceof MemoryOwner)) {
            throw new RuntimeException("Should create a MemoryOwner for MemoryTableWrite, but this is: " + writer.getClass());
        }
        this.memoryPoolFactory.notifyNewOwner((MemoryOwner)((Object)writer));
    }
}

