/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.util.Preconditions;

public abstract class TupleTypeInfoBase<T>
extends CompositeType<T> {
    private static final long serialVersionUID = 1L;
    private static final String REGEX_FIELD = "(f?)([0-9]+)";
    private static final String REGEX_NESTED_FIELDS = "((f?)([0-9]+))(\\.(.+))?";
    private static final String REGEX_NESTED_FIELDS_WILDCARD = "((f?)([0-9]+))(\\.(.+))?|\\*|\\_";
    private static final Pattern PATTERN_FIELD = Pattern.compile("(f?)([0-9]+)");
    private static final Pattern PATTERN_NESTED_FIELDS = Pattern.compile("((f?)([0-9]+))(\\.(.+))?");
    private static final Pattern PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile("((f?)([0-9]+))(\\.(.+))?|\\*|\\_");
    protected final TypeInformation<?>[] types;
    private final int totalFields;

    public TupleTypeInfoBase(Class<T> tupleType, TypeInformation<?> ... types) {
        super(tupleType);
        this.types = Preconditions.checkNotNull(types);
        int fieldCounter = 0;
        for (TypeInformation<?> type : types) {
            fieldCounter += type.getTotalFields();
        }
        this.totalFields = fieldCounter;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return true;
    }

    public boolean isCaseClass() {
        return false;
    }

    @Override
    public int getArity() {
        return this.types.length;
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.types;
    }

    @Override
    public int getTotalFields() {
        return this.totalFields;
    }

    @Override
    public void getFlatFields(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        Matcher matcher = PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
        if (!matcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid tuple field reference \"" + fieldExpression + "\".");
        }
        String field = matcher.group(0);
        if (field.equals("*") || field.equals("_")) {
            int keyPosition = 0;
            for (TypeInformation<?> type : this.types) {
                if (type instanceof CompositeType) {
                    CompositeType cType = (CompositeType)type;
                    cType.getFlatFields(String.valueOf("*"), offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    result.add(new CompositeType.FlatFieldDescriptor(offset + keyPosition, type));
                }
                ++keyPosition;
            }
        } else {
            String fieldStr = matcher.group(1);
            Matcher fieldMatcher = PATTERN_FIELD.matcher(fieldStr);
            if (!fieldMatcher.matches()) {
                throw new RuntimeException("Invalid matcher pattern");
            }
            field = fieldMatcher.group(2);
            int fieldPos = Integer.valueOf(field);
            if (fieldPos >= this.getArity()) {
                throw new CompositeType.InvalidFieldReferenceException("Tuple field expression \"" + fieldStr + "\" out of bounds of " + this.toString() + ".");
            }
            TypeInformation fieldType = this.getTypeAt(fieldPos);
            String tail = matcher.group(5);
            if (tail == null) {
                if (fieldType instanceof CompositeType) {
                    for (int i = 0; i < fieldPos; ++i) {
                        offset += this.getTypeAt(i).getTotalFields();
                    }
                    ((CompositeType)fieldType).getFlatFields("*", offset, result);
                } else {
                    int flatFieldPos = offset;
                    for (int i = 0; i < fieldPos; ++i) {
                        flatFieldPos += this.getTypeAt(i).getTotalFields();
                    }
                    result.add(new CompositeType.FlatFieldDescriptor(flatFieldPos, fieldType));
                }
            } else if (fieldType instanceof CompositeType) {
                for (int i = 0; i < fieldPos; ++i) {
                    offset += this.getTypeAt(i).getTotalFields();
                }
                ((CompositeType)fieldType).getFlatFields(tail, offset, result);
            } else {
                throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
            }
        }
    }

    @Override
    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS.matcher(fieldExpression);
        if (!matcher.matches()) {
            if (fieldExpression.equals("*") || fieldExpression.equals("_")) {
                throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
            }
            throw new CompositeType.InvalidFieldReferenceException("Invalid format of tuple field expression \"" + fieldExpression + "\".");
        }
        String fieldStr = matcher.group(1);
        Matcher fieldMatcher = PATTERN_FIELD.matcher(fieldStr);
        if (!fieldMatcher.matches()) {
            throw new RuntimeException("Invalid matcher pattern");
        }
        String field = fieldMatcher.group(2);
        int fieldPos = Integer.valueOf(field);
        if (fieldPos >= this.getArity()) {
            throw new CompositeType.InvalidFieldReferenceException("Tuple field expression \"" + fieldStr + "\" out of bounds of " + this.toString() + ".");
        }
        TypeInformation<X> fieldType = this.getTypeAt(fieldPos);
        String tail = matcher.group(5);
        if (tail == null) {
            return fieldType;
        }
        if (fieldType instanceof CompositeType) {
            return ((CompositeType)fieldType).getTypeAt(tail);
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    @Override
    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.types.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.types[pos];
        return typed;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfoBase) {
            TupleTypeInfoBase other = (TupleTypeInfoBase)obj;
            return other.canEqual(this) && super.equals(other) && Arrays.equals(this.types, other.types) && this.totalFields == other.totalFields;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof TupleTypeInfoBase;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * super.hashCode() + Arrays.hashCode(this.types)) + this.totalFields;
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder("Tuple");
        bld.append(this.types.length);
        if (this.types.length > 0) {
            bld.append('<').append(this.types[0]);
            for (int i = 1; i < this.types.length; ++i) {
                bld.append(", ").append(this.types[i]);
            }
            bld.append('>');
        }
        return bld.toString();
    }

    @Override
    public boolean hasDeterministicFieldOrder() {
        return true;
    }
}

