/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.runtime.operators.util.metrics.CountingMutableObjectIterator;
import org.apache.flink.runtime.util.NonReusingMutableToRegularIteratorWrapper;
import org.apache.flink.runtime.util.ReusingMutableToRegularIteratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllGroupCombineDriver<IN, OUT>
implements Driver<GroupCombineFunction<IN, OUT>, OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(AllGroupCombineDriver.class);
    private TaskContext<GroupCombineFunction<IN, OUT>, OUT> taskContext;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<GroupCombineFunction<IN, OUT>, OUT> context) {
        this.taskContext = context;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GroupCombineFunction<IN, OUT>> getStubType() {
        Class<GroupCombineFunction> clazz = GroupCombineFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() throws Exception {
        DriverStrategy driverStrategy = this.taskContext.getTaskConfig().getDriverStrategy();
        if (driverStrategy != DriverStrategy.ALL_GROUP_COMBINE) {
            throw new Exception("Invalid strategy " + (Object)((Object)driverStrategy) + " for GroupCombine.");
        }
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("GroupCombineDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("AllGroupCombine starting.");
        }
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        TypeSerializer serializer = serializerFactory.getSerializer();
        CountingMutableObjectIterator in = new CountingMutableObjectIterator(this.taskContext.getInput(0), numRecordsIn);
        GroupCombineFunction reducer = this.taskContext.getStub();
        CountingCollector<OUT> output = new CountingCollector<OUT>(this.taskContext.getOutputCollector(), numRecordsOut);
        if (this.objectReuseEnabled) {
            ReusingMutableToRegularIteratorWrapper inIter = new ReusingMutableToRegularIteratorWrapper(in, serializer);
            if (inIter.hasNext()) {
                reducer.combine(inIter, output);
            }
        } else {
            NonReusingMutableToRegularIteratorWrapper inIter = new NonReusingMutableToRegularIteratorWrapper(in, serializer);
            if (inIter.hasNext()) {
                reducer.combine(inIter, output);
            }
        }
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public void cancel() {
    }
}

