/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.util.FlinkRuntimeException;

@NotThreadSafe
@Internal
public final class SerializedCompositeKeyBuilder<K> {
    @Nonnull
    private final TypeSerializer<K> keySerializer;
    @Nonnull
    private final DataOutputSerializer keyOutView;
    @Nonnegative
    private final int keyGroupPrefixBytes;
    private final boolean keySerializerTypeVariableSized;
    @Nonnegative
    private int afterKeyMark;
    @Nonnegative
    private int afterNamespaceMark;

    public SerializedCompositeKeyBuilder(@Nonnull TypeSerializer<K> keySerializer, @Nonnegative int keyGroupPrefixBytes, @Nonnegative int initialSize) {
        this(keySerializer, new DataOutputSerializer(initialSize), keyGroupPrefixBytes, CompositeKeySerializationUtils.isSerializerTypeVariableSized(keySerializer), 0);
    }

    @VisibleForTesting
    SerializedCompositeKeyBuilder(@Nonnull TypeSerializer<K> keySerializer, @Nonnull DataOutputSerializer keyOutView, @Nonnegative int keyGroupPrefixBytes, boolean keySerializerTypeVariableSized, @Nonnegative int afterKeyMark) {
        this.keySerializer = keySerializer;
        this.keyOutView = keyOutView;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.keySerializerTypeVariableSized = keySerializerTypeVariableSized;
        this.afterKeyMark = afterKeyMark;
    }

    public void setKeyAndKeyGroup(@Nonnull K key, @Nonnegative int keyGroupId) {
        try {
            this.serializeKeyGroupAndKey(key, keyGroupId);
        }
        catch (IOException shouldNeverHappen) {
            throw new FlinkRuntimeException(shouldNeverHappen);
        }
    }

    public <N> void setNamespace(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer) {
        try {
            this.serializeNamespace(namespace, namespaceSerializer);
        }
        catch (IOException shouldNeverHappen) {
            throw new FlinkRuntimeException(shouldNeverHappen);
        }
    }

    @Nonnull
    public <N> byte[] buildCompositeKeyNamespace(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer) {
        try {
            this.serializeNamespace(namespace, namespaceSerializer);
            return this.keyOutView.getCopyOfBuffer();
        }
        catch (IOException shouldNeverHappen) {
            throw new FlinkRuntimeException(shouldNeverHappen);
        }
    }

    @Nonnull
    public <N, UK> byte[] buildCompositeKeyNamesSpaceUserKey(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull UK userKey, @Nonnull TypeSerializer<UK> userKeySerializer) throws IOException {
        this.serializeNamespace(namespace, namespaceSerializer);
        userKeySerializer.serialize(userKey, this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    @Nonnull
    public <UK> byte[] buildCompositeKeyUserKey(@Nonnull UK userKey, @Nonnull TypeSerializer<UK> userKeySerializer) throws IOException {
        assert (this.isNamespaceWritten());
        this.resetToNamespace();
        userKeySerializer.serialize(userKey, this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    @Nonnull
    public byte[] build() throws IOException {
        return this.keyOutView.getCopyOfBuffer();
    }

    private void serializeKeyGroupAndKey(K key, int keyGroupId) throws IOException {
        this.resetFully();
        CompositeKeySerializationUtils.writeKeyGroup(keyGroupId, this.keyGroupPrefixBytes, this.keyOutView);
        this.keySerializer.serialize(key, this.keyOutView);
        this.afterKeyMark = this.keyOutView.length();
    }

    private <N> void serializeNamespace(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer) throws IOException {
        assert (this.isKeyWritten());
        this.resetToKey();
        boolean ambiguousCompositeKeyPossible = this.isAmbiguousCompositeKeyPossible(namespaceSerializer);
        if (ambiguousCompositeKeyPossible) {
            CompositeKeySerializationUtils.writeVariableIntBytes(this.afterKeyMark - this.keyGroupPrefixBytes, this.keyOutView);
        }
        CompositeKeySerializationUtils.writeNameSpace(namespace, namespaceSerializer, this.keyOutView, ambiguousCompositeKeyPossible);
        this.afterNamespaceMark = this.keyOutView.length();
    }

    private void resetFully() {
        this.afterKeyMark = 0;
        this.afterNamespaceMark = 0;
        this.keyOutView.clear();
    }

    private void resetToKey() {
        this.afterNamespaceMark = 0;
        this.keyOutView.setPosition(this.afterKeyMark);
    }

    private void resetToNamespace() {
        this.keyOutView.setPosition(this.afterNamespaceMark);
    }

    private boolean isKeyWritten() {
        return this.afterKeyMark > 0;
    }

    private boolean isNamespaceWritten() {
        return this.afterNamespaceMark > 0;
    }

    @VisibleForTesting
    boolean isAmbiguousCompositeKeyPossible(TypeSerializer<?> namespaceSerializer) {
        return this.keySerializerTypeVariableSized & CompositeKeySerializationUtils.isSerializerTypeVariableSized(namespaceSerializer);
    }
}

