/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class PythonTableAggregateFunction
extends TableAggregateFunction
implements PythonFunction {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final byte[] serializedTableAggregateFunction;
    private final DataType[] inputTypes;
    private final DataType resultType;
    private final DataType accumulatorType;
    private final PythonFunctionKind pythonFunctionKind;
    private final boolean deterministic;
    private final PythonEnv pythonEnv;
    private final boolean takesRowAsInput;

    public PythonTableAggregateFunction(String name, byte[] serializedTableAggregateFunction, DataType[] inputTypes, DataType resultType, DataType accumulatorType, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this.name = name;
        this.serializedTableAggregateFunction = serializedTableAggregateFunction;
        this.inputTypes = inputTypes;
        this.resultType = resultType;
        this.accumulatorType = accumulatorType;
        this.pythonFunctionKind = pythonFunctionKind;
        this.deterministic = deterministic;
        this.pythonEnv = pythonEnv;
        this.takesRowAsInput = takesRowAsInput;
    }

    public void accumulate(Object accumulator, Object ... args) {
        throw new UnsupportedOperationException("This method is a placeholder and should not be called.");
    }

    public void emitValue(Object accumulator, Object out) {
        throw new UnsupportedOperationException("This method is a placeholder and should not be called.");
    }

    @Override
    public Object createAccumulator() {
        return null;
    }

    @Override
    public byte[] getSerializedPythonFunction() {
        return this.serializedTableAggregateFunction;
    }

    @Override
    public PythonEnv getPythonEnv() {
        return this.pythonEnv;
    }

    @Override
    public PythonFunctionKind getPythonFunctionKind() {
        return this.pythonFunctionKind;
    }

    @Override
    public boolean takesRowAsInput() {
        return this.takesRowAsInput;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public TypeInformation getResultType() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.resultType);
    }

    @Override
    public TypeInformation getAccumulatorType() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.accumulatorType);
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        if (this.inputTypes != null) {
            builder.typedArguments(this.inputTypes);
        }
        return builder.outputTypeStrategy(TypeStrategies.explicit(this.resultType)).accumulatorTypeStrategy(TypeStrategies.explicit(this.accumulatorType)).build();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

