/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class CompileAndExecutePlanOperation
implements Operation {
    private final String filePath;
    private final Operation operation;

    public CompileAndExecutePlanOperation(String filePath, Operation operation) {
        Preconditions.checkArgument(operation instanceof StatementSetOperation || operation instanceof ModifyOperation, "Child operation of CompileAndExecuteOperation must be either a ModifyOperation or a StatementSetOperation.");
        this.filePath = filePath;
        this.operation = operation;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public String asSummaryString() {
        return String.format("COMPILE AND EXECUTE PLAN '%s' FOR %s", this.filePath, this.operation.asSummaryString());
    }
}

