/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.util.Preconditions;

@Internal
public final class VaryingSequenceInputTypeStrategy
implements InputTypeStrategy {
    private final int constantArgumentCount;
    private final List<ArgumentTypeStrategy> constantArgumentStrategies;
    private final ArgumentTypeStrategy varyingArgumentStrategy;
    @Nullable
    private final List<String> argumentNames;

    public VaryingSequenceInputTypeStrategy(List<ArgumentTypeStrategy> argumentStrategies, @Nullable List<String> argumentNames) {
        Preconditions.checkArgument(argumentStrategies.size() > 0);
        Preconditions.checkArgument(argumentNames == null || argumentNames.size() == argumentStrategies.size());
        this.constantArgumentCount = argumentStrategies.size() - 1;
        this.constantArgumentStrategies = argumentStrategies.subList(0, this.constantArgumentCount);
        this.varyingArgumentStrategy = argumentStrategies.get(this.constantArgumentCount);
        this.argumentNames = argumentNames;
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.from(this.constantArgumentCount);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> dataTypes = callContext.getArgumentDataTypes();
        if (dataTypes.size() < this.constantArgumentCount) {
            return Optional.empty();
        }
        ArrayList<DataType> inferredDataTypes = new ArrayList<DataType>(dataTypes.size());
        for (int i = 0; i < callContext.getArgumentDataTypes().size(); ++i) {
            ArgumentTypeStrategy argumentTypeStrategy = i < this.constantArgumentCount ? this.constantArgumentStrategies.get(i) : this.varyingArgumentStrategy;
            Optional<DataType> inferredDataType = argumentTypeStrategy.inferArgumentType(callContext, i, throwOnFailure);
            if (!inferredDataType.isPresent()) {
                return Optional.empty();
            }
            inferredDataTypes.add(inferredDataType.get());
        }
        return Optional.of(inferredDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        Signature.Argument varyingArgument = this.varyingArgumentStrategy.getExpectedArgument(definition, this.constantArgumentCount);
        String type = varyingArgument.getType();
        Signature.Argument newArg = this.argumentNames == null ? Signature.Argument.of(type + "...") : Signature.Argument.of(this.argumentNames.get(this.constantArgumentCount), type + "...");
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>();
        for (int i = 0; i < this.constantArgumentCount; ++i) {
            if (this.argumentNames == null) {
                arguments.add(this.constantArgumentStrategies.get(i).getExpectedArgument(definition, i));
                continue;
            }
            arguments.add(Signature.Argument.of(this.argumentNames.get(i), this.constantArgumentStrategies.get(i).getExpectedArgument(definition, i).getType()));
        }
        arguments.add(newArg);
        return Collections.singletonList(Signature.of(arguments));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaryingSequenceInputTypeStrategy that = (VaryingSequenceInputTypeStrategy)o;
        return this.constantArgumentCount == that.constantArgumentCount && Objects.equals(this.constantArgumentStrategies, that.constantArgumentStrategies) && Objects.equals(this.varyingArgumentStrategy, that.varyingArgumentStrategy) && Objects.equals(this.argumentNames, that.argumentNames);
    }

    public int hashCode() {
        return Objects.hash(this.constantArgumentCount, this.constantArgumentStrategies, this.varyingArgumentStrategy, this.argumentNames);
    }
}

