/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.util.Preconditions;

class PartitionedFileReader {
    private final ByteBuffer headerBuf = BufferReaderWriterUtil.allocatedHeaderBuffer();
    private final ByteBuffer indexEntryBuf;
    private final PartitionedFile partitionedFile;
    private final int targetSubpartition;
    private final FileChannel dataFileChannel;
    private final FileChannel indexFileChannel;
    private int nextRegionToRead;
    private long nextOffsetToRead;
    private int currentRegionRemainingBuffers;

    PartitionedFileReader(PartitionedFile partitionedFile, int targetSubpartition, FileChannel dataFileChannel, FileChannel indexFileChannel) {
        Preconditions.checkArgument(Preconditions.checkNotNull(dataFileChannel).isOpen(), "Data file channel must be opened.");
        Preconditions.checkArgument(Preconditions.checkNotNull(indexFileChannel).isOpen(), "Index file channel must be opened.");
        this.partitionedFile = Preconditions.checkNotNull(partitionedFile);
        this.targetSubpartition = targetSubpartition;
        this.dataFileChannel = dataFileChannel;
        this.indexFileChannel = indexFileChannel;
        this.indexEntryBuf = ByteBuffer.allocateDirect(12);
        BufferReaderWriterUtil.configureByteBuffer(this.indexEntryBuf);
    }

    private void moveToNextReadableRegion() throws IOException {
        while (this.currentRegionRemainingBuffers <= 0 && this.nextRegionToRead < this.partitionedFile.getNumRegions()) {
            this.partitionedFile.getIndexEntry(this.indexFileChannel, this.indexEntryBuf, this.nextRegionToRead, this.targetSubpartition);
            this.nextOffsetToRead = this.indexEntryBuf.getLong();
            this.currentRegionRemainingBuffers = this.indexEntryBuf.getInt();
            ++this.nextRegionToRead;
        }
    }

    @Nullable
    Buffer readCurrentRegion(MemorySegment target, BufferRecycler recycler) throws IOException {
        if (this.currentRegionRemainingBuffers == 0) {
            return null;
        }
        this.dataFileChannel.position(this.nextOffsetToRead);
        Buffer buffer = BufferReaderWriterUtil.readFromByteChannel(this.dataFileChannel, this.headerBuf, target, recycler);
        this.nextOffsetToRead = this.dataFileChannel.position();
        --this.currentRegionRemainingBuffers;
        return buffer;
    }

    boolean hasRemaining() throws IOException {
        this.moveToNextReadableRegion();
        return this.currentRegionRemainingBuffers > 0;
    }

    long getPriority() {
        return this.nextOffsetToRead;
    }
}

