/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import java.sql.Date;
import org.apache.flink.table.store.utils.DateTimeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TableStoreDateObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements DateObjectInspector {
    public TableStoreDateObjectInspector() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : DateTimeUtils.toSQLDate((Integer)o);
    }

    public DateWritable getPrimitiveWritableObject(Object o) {
        Date date = this.getPrimitiveJavaObject(o);
        return date == null ? null : new DateWritable(date);
    }

    public Object copyObject(Object o) {
        if (o instanceof Date) {
            Date date = (Date)o;
            return new Date(date.getTime());
        }
        return o;
    }
}

