/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.data.DataFileMetaSerializer;
import org.apache.flink.table.store.file.utils.SerializationUtils;

public class Split {
    private final BinaryRowData partition;
    private final int bucket;
    private final List<DataFileMeta> files;
    private final boolean isIncremental;

    public Split(BinaryRowData partition, int bucket, List<DataFileMeta> files, boolean isIncremental) {
        this.partition = partition;
        this.bucket = bucket;
        this.files = files;
        this.isIncremental = isIncremental;
    }

    public BinaryRowData partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public List<DataFileMeta> files() {
        return this.files;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Split split = (Split)o;
        return this.bucket == split.bucket && Objects.equals(this.partition, split.partition) && Objects.equals(this.files, split.files) && this.isIncremental == split.isIncremental;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bucket, this.files, this.isIncremental);
    }

    public void serialize(DataOutputView out) throws IOException {
        SerializationUtils.serializeBinaryRow(this.partition, out);
        out.writeInt(this.bucket);
        out.writeInt(this.files.size());
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        for (DataFileMeta file : this.files) {
            dataFileSer.serialize(file, out);
        }
        out.writeBoolean(this.isIncremental);
    }

    public static Split deserialize(DataInputView in) throws IOException {
        BinaryRowData partition = SerializationUtils.deserializeBinaryRow(in);
        int bucket = in.readInt();
        int fileNumber = in.readInt();
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(fileNumber);
        DataFileMetaSerializer dataFileSer = new DataFileMetaSerializer();
        for (int i = 0; i < fileNumber; ++i) {
            files.add((DataFileMeta)dataFileSer.deserialize(in));
        }
        return new Split(partition, bucket, files, in.readBoolean());
    }
}

