/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class LongMaximum
implements SimpleAccumulator<Long> {
    private static final long serialVersionUID = 1L;
    private long max = Long.MIN_VALUE;

    public LongMaximum() {
    }

    public LongMaximum(long value) {
        this.max = value;
    }

    @Override
    public void add(Long value) {
        this.max = Math.max(this.max, value);
    }

    @Override
    public Long getLocalValue() {
        return this.max;
    }

    @Override
    public void merge(Accumulator<Long, Long> other) {
        this.max = Math.max(this.max, other.getLocalValue());
    }

    @Override
    public void resetLocal() {
        this.max = Long.MIN_VALUE;
    }

    public LongMaximum clone() {
        LongMaximum clone = new LongMaximum();
        clone.max = this.max;
        return clone;
    }

    @Override
    public void add(long value) {
        this.max = Math.max(this.max, value);
    }

    public long getLocalValuePrimitive() {
        return this.max;
    }

    public String toString() {
        return "LongMaximum " + this.max;
    }
}

