/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcTimeRangeBoundedPrecedingFunction<K>
extends KeyedProcessFunction<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProcTimeRangeBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingTimeBoundary;
    private transient ValueState<RowData> accState;
    private transient MapState<Long, List<RowData>> inputState;
    private transient ValueState<Long> cleanupTsState;
    private transient AggsHandleFunction function;
    private transient JoinedRowData output;

    public ProcTimeRangeBoundedPrecedingFunction(GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingTimeBoundary) {
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingTimeBoundary = precedingTimeBoundary;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo<RowData> rowListTypeInfo = new ListTypeInfo<RowData>(inputType);
        MapStateDescriptor<Long, RowData> mapStateDescriptor = new MapStateDescriptor<Long, RowData>("inputState", (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation<RowData>)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor<RowData> stateDescriptor = new ValueStateDescriptor<RowData>("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(stateDescriptor);
        ValueStateDescriptor<Long> cleanupTsStateDescriptor = new ValueStateDescriptor<Long>("cleanupTsState", Types.LONG);
        this.cleanupTsState = this.getRuntimeContext().getState(cleanupTsStateDescriptor);
    }

    @Override
    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        long currentTime = ctx.timerService().currentProcessingTime();
        List<RowData> rowList = this.inputState.get(currentTime);
        if (rowList == null) {
            rowList = new ArrayList<RowData>();
            ctx.timerService().registerProcessingTimeTimer(currentTime + 1L);
            this.registerCleanupTimer(ctx, currentTime);
        }
        rowList.add(input);
        this.inputState.put(currentTime, rowList);
    }

    private void registerCleanupTimer(KeyedProcessFunction.Context ctx, long timestamp) throws Exception {
        long minCleanupTimestamp = timestamp + this.precedingTimeBoundary + 1L;
        long maxCleanupTimestamp = timestamp + (long)((double)this.precedingTimeBoundary * 1.5) + 1L;
        Long curCleanupTimestamp = this.cleanupTsState.value();
        if (curCleanupTimestamp == null || curCleanupTimestamp < minCleanupTimestamp) {
            ctx.timerService().registerProcessingTimeTimer(maxCleanupTimestamp);
            this.cleanupTsState.update(maxCleanupTimestamp);
        }
    }

    @Override
    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        int iElemenets;
        Long cleanupTimestamp = this.cleanupTsState.value();
        if (cleanupTimestamp != null && cleanupTimestamp <= timestamp) {
            this.inputState.clear();
            this.accState.clear();
            this.cleanupTsState.clear();
            this.function.cleanup();
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        long currentTime = timestamp - 1L;
        List<RowData> currentElements = this.inputState.get(currentTime);
        if (null == currentElements) {
            return;
        }
        RowData accumulators = this.accState.value();
        if (null == accumulators) {
            accumulators = this.function.createAccumulators();
        }
        this.function.setAccumulators(accumulators);
        long limit = currentTime - this.precedingTimeBoundary;
        Iterator<Long> iter = this.inputState.keys().iterator();
        ArrayList<Long> markToRemove = new ArrayList<Long>();
        while (iter.hasNext()) {
            Long elementKey = iter.next();
            if (elementKey >= limit) continue;
            List<RowData> elementsRemove = this.inputState.get(elementKey);
            if (elementsRemove != null) {
                for (int iRemove = 0; iRemove < elementsRemove.size(); ++iRemove) {
                    RowData retractRow = elementsRemove.get(iRemove);
                    this.function.retract(retractRow);
                }
            } else {
                LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            }
            markToRemove.add(elementKey);
        }
        for (int i = 0; i < markToRemove.size(); ++i) {
            this.inputState.remove((Long)markToRemove.get(i));
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            RowData input = currentElements.get(iElemenets);
            this.function.accumulate(input);
        }
        RowData aggValue = this.function.getValue();
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            RowData input = currentElements.get(iElemenets);
            this.output.replace(input, aggValue);
            out.collect(this.output);
        }
        accumulators = this.function.getAccumulators();
        this.accState.update(accumulators);
    }

    @Override
    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

