/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.apache.flink.util.WrappingProxy;

public class PluginFileSystemFactory
implements FileSystemFactory {
    private final FileSystemFactory inner;
    private final ClassLoader loader;

    private PluginFileSystemFactory(FileSystemFactory inner, ClassLoader loader) {
        this.inner = inner;
        this.loader = loader;
    }

    public static PluginFileSystemFactory of(FileSystemFactory inner) {
        return new PluginFileSystemFactory(inner, inner.getClass().getClassLoader());
    }

    @Override
    public String getScheme() {
        return this.inner.getScheme();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.inner.getClassLoader();
    }

    @Override
    public void configure(Configuration config) {
        this.inner.configure(config);
    }

    @Override
    public FileSystem create(URI fsUri) throws IOException {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
            ClassLoaderFixingFileSystem classLoaderFixingFileSystem = new ClassLoaderFixingFileSystem(this.inner.create(fsUri), this.loader);
            return classLoaderFixingFileSystem;
        }
    }

    public String toString() {
        return String.format("Plugin %s", this.inner.getClass().getName());
    }

    static class ClassLoaderFixingFileSystem
    extends FileSystem
    implements WrappingProxy<FileSystem> {
        private final FileSystem inner;
        private final ClassLoader loader;

        private ClassLoaderFixingFileSystem(FileSystem inner, ClassLoader loader) {
            this.inner = inner;
            this.loader = loader;
        }

        @Override
        public Path getWorkingDirectory() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                Path path = this.inner.getWorkingDirectory();
                return path;
            }
        }

        @Override
        public Path getHomeDirectory() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                Path path = this.inner.getHomeDirectory();
                return path;
            }
        }

        @Override
        public URI getUri() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                URI uRI = this.inner.getUri();
                return uRI;
            }
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                FileStatus fileStatus = this.inner.getFileStatus(f);
                return fileStatus;
            }
        }

        @Override
        public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                BlockLocation[] blockLocationArray = this.inner.getFileBlockLocations(file, start, len);
                return blockLocationArray;
            }
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                FSDataInputStream fSDataInputStream = this.inner.open(f, bufferSize);
                return fSDataInputStream;
            }
        }

        @Override
        public FSDataInputStream open(Path f) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                FSDataInputStream fSDataInputStream = this.inner.open(f);
                return fSDataInputStream;
            }
        }

        @Override
        public RecoverableWriter createRecoverableWriter() throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                RecoverableWriter recoverableWriter = this.inner.createRecoverableWriter();
                return recoverableWriter;
            }
        }

        @Override
        public FileStatus[] listStatus(Path f) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                FileStatus[] fileStatusArray = this.inner.listStatus(f);
                return fileStatusArray;
            }
        }

        @Override
        public boolean exists(Path f) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                boolean bl = this.inner.exists(f);
                return bl;
            }
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                boolean bl = this.inner.delete(f, recursive);
                return bl;
            }
        }

        @Override
        public boolean mkdirs(Path f) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                boolean bl = this.inner.mkdirs(f);
                return bl;
            }
        }

        @Override
        public FSDataOutputStream create(Path f, FileSystem.WriteMode overwriteMode) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                FSDataOutputStream fSDataOutputStream = this.inner.create(f, overwriteMode);
                return fSDataOutputStream;
            }
        }

        @Override
        public boolean isDistributedFS() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                boolean bl = this.inner.isDistributedFS();
                return bl;
            }
        }

        @Override
        public FileSystemKind getKind() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                FileSystemKind fileSystemKind = this.inner.getKind();
                return fileSystemKind;
            }
        }

        @Override
        public boolean rename(Path src, Path dst) throws IOException {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.loader);){
                boolean bl = this.inner.rename(src, dst);
                return bl;
            }
        }

        @Override
        public FileSystem getWrappedDelegate() {
            return this.inner;
        }
    }
}

