/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class IntegerTypeInfo<T>
extends NumericTypeInfo<T> {
    private static final long serialVersionUID = -8068827354966766955L;
    private static final HashSet<Class<?>> integerTypes = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Byte.class, Short.class, Character.class));

    protected IntegerTypeInfo(Class<T> clazz, Class<?>[] possibleCastTargetTypes, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        super(clazz, possibleCastTargetTypes, serializer, comparatorClass);
        Preconditions.checkArgument(integerTypes.contains(clazz), "The given class %s is not a integer type.", clazz.getSimpleName());
    }
}

