/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.AbstractReferenceCountedByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.util.Preconditions;

public class NetworkBuffer
extends AbstractReferenceCountedByteBuf
implements Buffer {
    private final MemorySegment memorySegment;
    private final BufferRecycler recycler;
    private Buffer.DataType dataType;
    private ByteBufAllocator allocator;
    private int currentSize;
    private boolean isCompressed = false;

    public NetworkBuffer(MemorySegment memorySegment, BufferRecycler recycler) {
        this(memorySegment, recycler, Buffer.DataType.DATA_BUFFER);
    }

    public NetworkBuffer(MemorySegment memorySegment, BufferRecycler recycler, Buffer.DataType dataType) {
        this(memorySegment, recycler, dataType, 0);
    }

    public NetworkBuffer(MemorySegment memorySegment, BufferRecycler recycler, Buffer.DataType dataType, int size) {
        this(memorySegment, recycler, dataType, false, size);
    }

    public NetworkBuffer(MemorySegment memorySegment, BufferRecycler recycler, Buffer.DataType dataType, boolean isCompressed, int size) {
        super(memorySegment.size());
        this.memorySegment = Preconditions.checkNotNull(memorySegment);
        this.recycler = Preconditions.checkNotNull(recycler);
        this.dataType = dataType;
        this.isCompressed = isCompressed;
        this.currentSize = memorySegment.size();
        this.setSize(size);
    }

    @Override
    public boolean isBuffer() {
        return this.dataType.isBuffer();
    }

    @Override
    public MemorySegment getMemorySegment() {
        this.ensureAccessible();
        return this.memorySegment;
    }

    @Override
    public int getMemorySegmentOffset() {
        return 0;
    }

    @Override
    public BufferRecycler getRecycler() {
        return this.recycler;
    }

    @Override
    public void recycleBuffer() {
        this.release();
    }

    @Override
    public boolean isRecycled() {
        return this.refCnt() == 0;
    }

    @Override
    public NetworkBuffer retainBuffer() {
        return (NetworkBuffer)super.retain();
    }

    @Override
    public ReadOnlySlicedNetworkBuffer readOnlySlice() {
        return this.readOnlySlice(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ReadOnlySlicedNetworkBuffer readOnlySlice(int index, int length) {
        Preconditions.checkState(!this.isCompressed, "Unable to slice a compressed buffer.");
        return new ReadOnlySlicedNetworkBuffer(this, index, length);
    }

    protected void deallocate() {
        this.recycler.recycle(this.memorySegment);
    }

    protected byte _getByte(int index) {
        return this.memorySegment.get(index);
    }

    protected short _getShort(int index) {
        return this.memorySegment.getShortBigEndian(index);
    }

    protected short _getShortLE(int index) {
        return this.memorySegment.getShortLittleEndian(index);
    }

    protected int _getUnsignedMedium(int index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | this.getByte(index + 2) & 0xFF;
    }

    protected int _getUnsignedMediumLE(int index) {
        return this.getByte(index) & 0xFF | (this.getByte(index + 1) & 0xFF) << 8 | (this.getByte(index + 2) & 0xFF) << 16;
    }

    protected int _getInt(int index) {
        return this.memorySegment.getIntBigEndian(index);
    }

    protected int _getIntLE(int index) {
        return this.memorySegment.getIntLittleEndian(index);
    }

    protected long _getLong(int index) {
        return this.memorySegment.getLongBigEndian(index);
    }

    protected long _getLongLE(int index) {
        return this.memorySegment.getLongLittleEndian(index);
    }

    protected void _setByte(int index, int value) {
        this.memorySegment.put(index, (byte)value);
    }

    protected void _setShort(int index, int value) {
        this.memorySegment.putShortBigEndian(index, (short)value);
    }

    protected void _setShortLE(int index, int value) {
        this.memorySegment.putShortLittleEndian(index, (short)value);
    }

    protected void _setMedium(int index, int value) {
        this.setByte(index, (byte)(value >>> 16));
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)value);
    }

    protected void _setMediumLE(int index, int value) {
        this.setByte(index, (byte)value);
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)(value >>> 16));
    }

    protected void _setInt(int index, int value) {
        this.memorySegment.putIntBigEndian(index, value);
    }

    protected void _setIntLE(int index, int value) {
        this.memorySegment.putIntLittleEndian(index, value);
    }

    protected void _setLong(int index, long value) {
        this.memorySegment.putLongBigEndian(index, value);
    }

    protected void _setLongLE(int index, long value) {
        this.memorySegment.putLongLittleEndian(index, value);
    }

    public int capacity() {
        return this.currentSize;
    }

    @Override
    public int getMaxCapacity() {
        return this.maxCapacity();
    }

    @Override
    public int getReaderIndex() {
        return this.readerIndex();
    }

    @Override
    public void setReaderIndex(int readerIndex) throws IndexOutOfBoundsException {
        this.readerIndex(readerIndex);
    }

    @Override
    public int getSize() {
        return this.writerIndex();
    }

    @Override
    public void setSize(int writerIndex) {
        this.writerIndex(writerIndex);
    }

    public ByteBuf capacity(int newCapacity) {
        this.ensureAccessible();
        if (newCapacity < 0 || newCapacity > this.maxCapacity()) {
            throw new IllegalArgumentException("Size of buffer must be >= 0 and <= " + this.memorySegment.size() + ", but was " + newCapacity + ".");
        }
        this.currentSize = newCapacity;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public ByteBuf unwrap() {
        return null;
    }

    public boolean isDirect() {
        return this.memorySegment.isOffHeap();
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                this.getBytes(index, bb);
                index += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, (ByteBuf)this, index, length);
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        this.memorySegment.get(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        this.memorySegment.get(index, dst, dst.remaining());
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return this;
        }
        if (this.memorySegment.isOffHeap()) {
            byte[] tmp = new byte[length];
            ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
            tmpBuf.get(tmp);
            out.write(tmp);
        } else {
            out.write(this.memorySegment.getArray(), index, length);
        }
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
        return out.write(tmpBuf);
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        this.checkIndex(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
        return out.write(tmpBuf, position);
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        if (src.nioBufferCount() > 0) {
            for (ByteBuffer bb : src.nioBuffers(srcIndex, length)) {
                int bbLen = bb.remaining();
                this.setBytes(index, bb);
                index += bbLen;
            }
        } else {
            src.getBytes(srcIndex, (ByteBuf)this, index, length);
        }
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.length);
        ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
        tmpBuf.put(src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        ByteBuffer tmpBuf = this.memorySegment.wrap(index, src.remaining());
        tmpBuf.put(src);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        if (this.memorySegment.isOffHeap()) {
            byte[] tmp = new byte[length];
            int readBytes = in.read(tmp);
            if (readBytes <= 0) {
                return readBytes;
            }
            ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
            tmpBuf.put(tmp, 0, readBytes);
            return readBytes;
        }
        return in.read(this.memorySegment.getArray(), index, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
        try {
            return in.read(tmpBuf);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        this.checkIndex(index, length);
        ByteBuffer tmpBuf = this.memorySegment.wrap(index, length);
        try {
            return in.read(tmpBuf, position);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    public ByteBufAllocator alloc() {
        return Preconditions.checkNotNull(this.allocator);
    }

    @Override
    public void setAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        ByteBuf copy = this.alloc().buffer(length, this.maxCapacity());
        copy.writeBytes((ByteBuf)this, index, length);
        return copy;
    }

    public ByteBuf readBytes(int length) {
        this.checkReadableBytes(length);
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buf = this.alloc().buffer(length, this.maxCapacity());
        int readerIndex = this.readerIndex();
        buf.writeBytes((ByteBuf)this, readerIndex, length);
        this.readerIndex(readerIndex + length);
        return buf;
    }

    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer getNioBufferReadable() {
        return this.nioBuffer();
    }

    @Override
    public ByteBuffer getNioBuffer(int index, int length) {
        return this.nioBuffer(index, length);
    }

    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.memorySegment.wrap(index, length).slice();
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.nioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    public boolean hasArray() {
        return !this.memorySegment.isOffHeap();
    }

    public byte[] array() {
        this.ensureAccessible();
        return this.memorySegment.getArray();
    }

    public int arrayOffset() {
        return 0;
    }

    public boolean hasMemoryAddress() {
        return this.memorySegment.isOffHeap();
    }

    public long memoryAddress() {
        return this.memorySegment.getAddress();
    }

    public String toString() {
        if (this.refCnt() == 0) {
            return String.format("Buffer %s (freed)", this.hashCode());
        }
        StringBuilder buf = new StringBuilder().append("Buffer ").append(this.hashCode()).append(" (ridx: ").append(this.readerIndex()).append(", widx: ").append(this.writerIndex()).append(", cap: ").append(this.capacity());
        if (this.maxCapacity() != Integer.MAX_VALUE) {
            buf.append('/').append(this.maxCapacity());
        }
        buf.append(", ref count: ").append(this.refCnt()).append(')');
        return buf.toString();
    }

    @Override
    public ByteBuf asByteBuf() {
        return this;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public Buffer.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(Buffer.DataType dataType) {
        this.ensureAccessible();
        this.dataType = dataType;
    }
}

