/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.util.Preconditions;

public class ResultPartitionMetrics {
    private final ResultPartition partition;

    private ResultPartitionMetrics(ResultPartition partition) {
        this.partition = Preconditions.checkNotNull(partition);
    }

    long refreshAndGetTotal() {
        return this.partition.getNumberOfQueuedBuffers();
    }

    int refreshAndGetMin() {
        int min = Integer.MAX_VALUE;
        int numSubpartitions = this.partition.getNumberOfSubpartitions();
        if (numSubpartitions == 0) {
            return 0;
        }
        for (int targetSubpartition = 0; targetSubpartition < numSubpartitions; ++targetSubpartition) {
            int size = this.partition.getNumberOfQueuedBuffers(targetSubpartition);
            min = Math.min(min, size);
        }
        return min;
    }

    int refreshAndGetMax() {
        int max = 0;
        int numSubpartitions = this.partition.getNumberOfSubpartitions();
        for (int targetSubpartition = 0; targetSubpartition < numSubpartitions; ++targetSubpartition) {
            int size = this.partition.getNumberOfQueuedBuffers(targetSubpartition);
            max = Math.max(max, size);
        }
        return max;
    }

    float refreshAndGetAvg() {
        return (float)this.partition.getNumberOfQueuedBuffers() / (float)this.partition.getNumberOfSubpartitions();
    }

    private Gauge<Long> getTotalQueueLenGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return ResultPartitionMetrics.this.refreshAndGetTotal();
            }
        };
    }

    private Gauge<Integer> getMinQueueLenGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return ResultPartitionMetrics.this.refreshAndGetMin();
            }
        };
    }

    private Gauge<Integer> getMaxQueueLenGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return ResultPartitionMetrics.this.refreshAndGetMax();
            }
        };
    }

    private Gauge<Float> getAvgQueueLenGauge() {
        return new Gauge<Float>(){

            public Float getValue() {
                return Float.valueOf(ResultPartitionMetrics.this.refreshAndGetAvg());
            }
        };
    }

    public static void registerQueueLengthMetrics(MetricGroup parent, ResultPartition[] partitions) {
        for (int i = 0; i < partitions.length; ++i) {
            ResultPartitionMetrics metrics = new ResultPartitionMetrics(partitions[i]);
            MetricGroup group = parent.addGroup(i);
            group.gauge("totalQueueLen", metrics.getTotalQueueLenGauge());
            group.gauge("minQueueLen", metrics.getMinQueueLenGauge());
            group.gauge("maxQueueLen", metrics.getMaxQueueLenGauge());
            group.gauge("avgQueueLen", metrics.getAvgQueueLenGauge());
        }
    }
}

