/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;

public class ResourceManagerProcessContext {
    private final Configuration rmConfig;
    private final ResourceID resourceId;
    private final ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final HeartbeatServices heartbeatServices;
    private final FatalErrorHandler fatalErrorHandler;
    private final ClusterInformation clusterInformation;
    @Nullable
    private final String webInterfaceUrl;
    private final ResourceManagerMetricGroup resourceManagerMetricGroup;
    private final SlotManagerMetricGroup slotManagerMetricGroup;
    private final Executor ioExecutor;

    public ResourceManagerProcessContext(Configuration rmConfig, ResourceID resourceId, ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, ResourceManagerMetricGroup resourceManagerMetricGroup, SlotManagerMetricGroup slotManagerMetricGroup, Executor ioExecutor) {
        this.rmConfig = Preconditions.checkNotNull(rmConfig);
        this.resourceId = Preconditions.checkNotNull(resourceId);
        this.rmRuntimeServicesConfig = Preconditions.checkNotNull(rmRuntimeServicesConfig);
        this.rpcService = Preconditions.checkNotNull(rpcService);
        this.highAvailabilityServices = Preconditions.checkNotNull(highAvailabilityServices);
        this.heartbeatServices = Preconditions.checkNotNull(heartbeatServices);
        this.fatalErrorHandler = Preconditions.checkNotNull(fatalErrorHandler);
        this.clusterInformation = Preconditions.checkNotNull(clusterInformation);
        this.resourceManagerMetricGroup = Preconditions.checkNotNull(resourceManagerMetricGroup);
        this.slotManagerMetricGroup = Preconditions.checkNotNull(slotManagerMetricGroup);
        this.ioExecutor = Preconditions.checkNotNull(ioExecutor);
        this.webInterfaceUrl = webInterfaceUrl;
    }

    public Configuration getRmConfig() {
        return this.rmConfig;
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    public ResourceManagerRuntimeServicesConfiguration getRmRuntimeServicesConfig() {
        return this.rmRuntimeServicesConfig;
    }

    public RpcService getRpcService() {
        return this.rpcService;
    }

    public HighAvailabilityServices getHighAvailabilityServices() {
        return this.highAvailabilityServices;
    }

    public HeartbeatServices getHeartbeatServices() {
        return this.heartbeatServices;
    }

    public FatalErrorHandler getFatalErrorHandler() {
        return this.fatalErrorHandler;
    }

    public ClusterInformation getClusterInformation() {
        return this.clusterInformation;
    }

    @Nullable
    public String getWebInterfaceUrl() {
        return this.webInterfaceUrl;
    }

    public ResourceManagerMetricGroup getResourceManagerMetricGroup() {
        return this.resourceManagerMetricGroup;
    }

    public SlotManagerMetricGroup getSlotManagerMetricGroup() {
        return this.slotManagerMetricGroup;
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }
}

