/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.metrics.DoubleAccumulator;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractAggregatedMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractAggregatedMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetric;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetricsResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsAggregationParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsFilterParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.Preconditions;

public abstract class AbstractAggregatingMetricsHandler<P extends AbstractAggregatedMetricsParameters<?>>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, AggregatedMetricsResponseBody, P> {
    private final Executor executor;
    private final MetricFetcher fetcher;

    protected AbstractAggregatingMetricsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, AbstractAggregatedMetricsHeaders<P> messageHeaders, Executor executor, MetricFetcher fetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.executor = Preconditions.checkNotNull(executor);
        this.fetcher = Preconditions.checkNotNull(fetcher);
    }

    @Nonnull
    abstract Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore var1, HandlerRequest<EmptyRequestBody> var2);

    @Override
    protected CompletableFuture<AggregatedMetricsResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.fetcher.update();
                List<String> requestedMetrics = request.getQueryParameter(MetricsFilterParameter.class);
                List requestedAggregations = request.getQueryParameter(MetricsAggregationParameter.class);
                MetricStore store = this.fetcher.getMetricStore();
                Collection<MetricStore.ComponentMetricStore> stores = this.getStores(store, request);
                if (requestedMetrics.isEmpty()) {
                    Collection<String> list = AbstractAggregatingMetricsHandler.getAvailableMetrics(stores);
                    return new AggregatedMetricsResponseBody(list.stream().map(AggregatedMetric::new).collect(Collectors.toList()));
                }
                DoubleAccumulator.DoubleMinimumFactory minimumFactory = null;
                DoubleAccumulator.DoubleMaximumFactory maximumFactory = null;
                DoubleAccumulator.DoubleAverageFactory averageFactory = null;
                DoubleAccumulator.DoubleSumFactory sumFactory = null;
                if (requestedAggregations.isEmpty()) {
                    minimumFactory = DoubleAccumulator.DoubleMinimumFactory.get();
                    maximumFactory = DoubleAccumulator.DoubleMaximumFactory.get();
                    averageFactory = DoubleAccumulator.DoubleAverageFactory.get();
                    sumFactory = DoubleAccumulator.DoubleSumFactory.get();
                } else {
                    block8: for (MetricsAggregationParameter.AggregationMode aggregation : requestedAggregations) {
                        switch (aggregation) {
                            case MIN: {
                                minimumFactory = DoubleAccumulator.DoubleMinimumFactory.get();
                                continue block8;
                            }
                            case MAX: {
                                maximumFactory = DoubleAccumulator.DoubleMaximumFactory.get();
                                continue block8;
                            }
                            case AVG: {
                                averageFactory = DoubleAccumulator.DoubleAverageFactory.get();
                                continue block8;
                            }
                            case SUM: {
                                sumFactory = DoubleAccumulator.DoubleSumFactory.get();
                                continue block8;
                            }
                        }
                        this.log.warn("Unsupported aggregation specified: {}", (Object)aggregation);
                    }
                }
                MetricAccumulatorFactory metricAccumulatorFactory = new MetricAccumulatorFactory(minimumFactory, maximumFactory, averageFactory, sumFactory);
                return this.getAggregatedMetricValues(stores, requestedMetrics, metricAccumulatorFactory);
            }
            catch (Exception e) {
                this.log.warn("Could not retrieve metrics.", (Throwable)e);
                throw new CompletionException(new RestHandlerException("Could not retrieve metrics.", HttpResponseStatus.INTERNAL_SERVER_ERROR));
            }
        }, this.executor);
    }

    private static Collection<String> getAvailableMetrics(Collection<? extends MetricStore.ComponentMetricStore> stores) {
        HashSet<String> uniqueMetrics = new HashSet<String>(32);
        for (MetricStore.ComponentMetricStore componentMetricStore : stores) {
            uniqueMetrics.addAll(componentMetricStore.metrics.keySet());
        }
        return uniqueMetrics;
    }

    private AggregatedMetricsResponseBody getAggregatedMetricValues(Collection<? extends MetricStore.ComponentMetricStore> stores, List<String> requestedMetrics, MetricAccumulatorFactory requestedAggregationsFactories) {
        ArrayList<AggregatedMetric> aggregatedMetrics = new ArrayList<AggregatedMetric>(requestedMetrics.size());
        for (String requestedMetric : requestedMetrics) {
            ArrayList<Double> values = new ArrayList<Double>(stores.size());
            try {
                for (MetricStore.ComponentMetricStore componentMetricStore : stores) {
                    String stringValue = componentMetricStore.metrics.get(requestedMetric);
                    if (stringValue == null) continue;
                    values.add(Double.valueOf(stringValue));
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn("The metric {} is not numeric and can't be aggregated.", (Object)requestedMetric, (Object)nfe);
                continue;
            }
            if (!values.isEmpty()) {
                Iterator<Double> valuesIterator = values.iterator();
                MetricAccumulator metricAccumulator = requestedAggregationsFactories.get(requestedMetric, (Double)valuesIterator.next());
                valuesIterator.forEachRemaining(metricAccumulator::add);
                aggregatedMetrics.add(metricAccumulator.get());
                continue;
            }
            return new AggregatedMetricsResponseBody(Collections.emptyList());
        }
        return new AggregatedMetricsResponseBody(aggregatedMetrics);
    }

    private static class MetricAccumulator {
        private final String metricName;
        @Nullable
        private final DoubleAccumulator min;
        @Nullable
        private final DoubleAccumulator max;
        @Nullable
        private final DoubleAccumulator avg;
        @Nullable
        private final DoubleAccumulator sum;

        private MetricAccumulator(String metricName, @Nullable DoubleAccumulator min, @Nullable DoubleAccumulator max, @Nullable DoubleAccumulator avg, @Nullable DoubleAccumulator sum) {
            this.metricName = Preconditions.checkNotNull(metricName);
            this.min = min;
            this.max = max;
            this.avg = avg;
            this.sum = sum;
        }

        void add(double value) {
            if (this.min != null) {
                this.min.add(value);
            }
            if (this.max != null) {
                this.max.add(value);
            }
            if (this.avg != null) {
                this.avg.add(value);
            }
            if (this.sum != null) {
                this.sum.add(value);
            }
        }

        AggregatedMetric get() {
            return new AggregatedMetric(this.metricName, this.min == null ? null : Double.valueOf(this.min.getValue()), this.max == null ? null : Double.valueOf(this.max.getValue()), this.avg == null ? null : Double.valueOf(this.avg.getValue()), this.sum == null ? null : Double.valueOf(this.sum.getValue()));
        }
    }

    private static class MetricAccumulatorFactory {
        @Nullable
        private final DoubleAccumulator.DoubleMinimumFactory minimumFactory;
        @Nullable
        private final DoubleAccumulator.DoubleMaximumFactory maximumFactory;
        @Nullable
        private final DoubleAccumulator.DoubleAverageFactory averageFactory;
        @Nullable
        private final DoubleAccumulator.DoubleSumFactory sumFactory;

        private MetricAccumulatorFactory(@Nullable DoubleAccumulator.DoubleMinimumFactory minimumFactory, @Nullable DoubleAccumulator.DoubleMaximumFactory maximumFactory, @Nullable DoubleAccumulator.DoubleAverageFactory averageFactory, @Nullable DoubleAccumulator.DoubleSumFactory sumFactory) {
            this.minimumFactory = minimumFactory;
            this.maximumFactory = maximumFactory;
            this.averageFactory = averageFactory;
            this.sumFactory = sumFactory;
        }

        MetricAccumulator get(String metricName, double init) {
            return new MetricAccumulator(metricName, this.minimumFactory == null ? null : this.minimumFactory.get(init), this.maximumFactory == null ? null : this.maximumFactory.get(init), this.averageFactory == null ? null : this.averageFactory.get(init), this.sumFactory == null ? null : this.sumFactory.get(init));
        }
    }
}

