/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async;

import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperator;

public class AsyncWaitOperatorFactory<IN, OUT>
extends AbstractStreamOperatorFactory<OUT>
implements OneInputStreamOperatorFactory<IN, OUT>,
YieldingOperatorFactory<OUT> {
    private final AsyncFunction<IN, OUT> asyncFunction;
    private final long timeout;
    private final int capacity;
    private final AsyncDataStream.OutputMode outputMode;

    public AsyncWaitOperatorFactory(AsyncFunction<IN, OUT> asyncFunction, long timeout, int capacity, AsyncDataStream.OutputMode outputMode) {
        this.asyncFunction = asyncFunction;
        this.timeout = timeout;
        this.capacity = capacity;
        this.outputMode = outputMode;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        AsyncWaitOperator<IN, OUT> asyncWaitOperator = new AsyncWaitOperator<IN, OUT>(this.asyncFunction, this.timeout, this.capacity, this.outputMode, this.processingTimeService, this.getMailboxExecutor());
        asyncWaitOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        return (T)asyncWaitOperator;
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return AsyncWaitOperator.class;
    }
}

