/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.operators.deduplicate.MiniBatchDeduplicateFunctionBase;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class RowTimeMiniBatchLatestChangeDeduplicateFunction
extends MiniBatchDeduplicateFunctionBase<RowData, RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<RowData> serializer;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final int rowtimeIndex;
    private final boolean keepLastRow;

    public RowTimeMiniBatchLatestChangeDeduplicateFunction(InternalTypeInfo<RowData> typeInfo, TypeSerializer<RowData> serializer, long minRetentionTime, int rowtimeIndex, boolean generateUpdateBefore, boolean generateInsert, boolean keepLastRow) {
        super(typeInfo, minRetentionTime);
        this.serializer = serializer;
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.rowtimeIndex = rowtimeIndex;
        this.keepLastRow = keepLastRow;
    }

    @Override
    public RowData addInput(@Nullable RowData value, RowData input) throws Exception {
        if (DeduplicateFunctionHelper.isDuplicate(value, input, this.rowtimeIndex, this.keepLastRow)) {
            return this.serializer.copy(input);
        }
        return value;
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData bufferedRow = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            RowData preRow = (RowData)this.state.value();
            DeduplicateFunctionHelper.checkInsertOnly(bufferedRow);
            if (!DeduplicateFunctionHelper.isDuplicate(preRow, bufferedRow, this.rowtimeIndex, this.keepLastRow)) continue;
            DeduplicateFunctionHelper.updateDeduplicateResult(this.generateUpdateBefore, this.generateInsert, preRow, bufferedRow, out);
            this.state.update(bufferedRow);
        }
    }
}

