/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.output;

import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.output.ExceptionInMultipleInputOperatorException;
import org.apache.flink.table.runtime.operators.multipleinput.output.OutputBase;
import org.apache.flink.util.OutputTag;

public class OneInputStreamOperatorOutput
extends OutputBase {
    private final OneInputStreamOperator<RowData, RowData> operator;

    public OneInputStreamOperatorOutput(OneInputStreamOperator<RowData, RowData> operator) {
        super(operator);
        this.operator = operator;
    }

    @Override
    public void emitWatermark(Watermark mark) {
        try {
            this.operator.processWatermark(mark);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        try {
            this.operator.processWatermarkStatus(watermarkStatus);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        try {
            this.operator.processLatencyMarker(latencyMarker);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }

    @Override
    public void collect(StreamRecord<RowData> record) {
        this.pushToOperator(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        this.pushToOperator(record);
    }

    protected <X> void pushToOperator(StreamRecord<X> record) {
        try {
            StreamRecord<X> castRecord = record;
            this.operator.processElement(castRecord);
        }
        catch (Exception e) {
            throw new ExceptionInMultipleInputOperatorException(e);
        }
    }
}

