/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.spark.SparkInternalRow;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.utils.TypeUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;

public class SparkInputPartition
implements InputPartition<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable table;
    private final int[] projectedFields;
    private final List<Predicate> predicates;
    private transient Split split;

    public SparkInputPartition(FileStoreTable table, int[] projectedFields, List<Predicate> predicates, Split split) {
        this.table = table;
        this.projectedFields = projectedFields;
        this.predicates = predicates;
        this.split = split;
    }

    public InputPartitionReader<InternalRow> createPartitionReader() {
        RecordReader<RowData> recordReader;
        try {
            TableRead tableRead = this.table.newRead();
            if (this.projectedFields != null) {
                tableRead.withProjection(this.projectedFields);
            }
            if (this.predicates.size() > 0) {
                tableRead.withFilter(PredicateBuilder.and(this.predicates));
            }
            recordReader = tableRead.createReader(this.split);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        final RecordReaderIterator<RowData> iterator = new RecordReaderIterator<RowData>(recordReader);
        final SparkInternalRow row = new SparkInternalRow(this.readRowType());
        return new InputPartitionReader<InternalRow>(){

            public boolean next() {
                if (iterator.hasNext()) {
                    row.replace((RowData)iterator.next());
                    return true;
                }
                return false;
            }

            public InternalRow get() {
                return row;
            }

            public void close() throws IOException {
                try {
                    iterator.close();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public String[] preferredLocations() {
        return new String[0];
    }

    private RowType readRowType() {
        RowType rowType = this.table.schema().logicalRowType();
        return this.projectedFields == null ? rowType : TypeUtils.project(rowType, this.projectedFields);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.split.serialize(new DataOutputViewStreamWrapper(out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.split = Split.deserialize(new DataInputViewStreamWrapper(in));
    }
}

