/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.FileStore;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.sink.TableCommit;
import org.apache.flink.table.store.table.sink.TableCompact;

public abstract class AbstractFileStoreTable
implements FileStoreTable {
    private static final long serialVersionUID = 1L;
    private final Path path;
    protected final TableSchema tableSchema;

    public AbstractFileStoreTable(Path path, TableSchema tableSchema) {
        this.path = path;
        this.tableSchema = tableSchema;
    }

    protected abstract FileStore<?> store();

    @Override
    public Path location() {
        return this.path;
    }

    @Override
    public TableSchema schema() {
        return this.tableSchema;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.store().snapshotManager();
    }

    @Override
    public TableCommit newCommit(String user) {
        return new TableCommit(this.store().newCommit(user), this.store().newExpire());
    }

    @Override
    public TableCompact newCompact() {
        return new TableCompact(this.store().newScan(), this.store().newWrite(), this.store().partitionType());
    }
}

