/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.SplitGenerator;

public abstract class TableScan {
    private final FileStoreScan scan;
    private final TableSchema tableSchema;
    private final FileStorePathFactory pathFactory;
    private boolean isIncremental = false;

    protected TableScan(FileStoreScan scan, TableSchema tableSchema, FileStorePathFactory pathFactory) {
        this.scan = scan;
        this.tableSchema = tableSchema;
        this.pathFactory = pathFactory;
    }

    public TableScan withSnapshot(long snapshotId) {
        this.scan.withSnapshot(snapshotId);
        return this;
    }

    public TableScan withFilter(List<Predicate> predicates) {
        if (predicates == null || predicates.isEmpty()) {
            return this;
        }
        return this.withFilter(PredicateBuilder.and(predicates));
    }

    public TableScan withFilter(Predicate predicate) {
        List<String> partitionKeys = this.tableSchema.partitionKeys();
        int[] fieldIdxToPartitionIdx = this.tableSchema.fields().stream().mapToInt(f -> partitionKeys.indexOf(f.name())).toArray();
        ArrayList<Predicate> partitionFilters = new ArrayList<Predicate>();
        ArrayList<Predicate> nonPartitionFilters = new ArrayList<Predicate>();
        for (Predicate p : PredicateBuilder.splitAnd(predicate)) {
            Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(p, fieldIdxToPartitionIdx);
            if (mapped.isPresent()) {
                partitionFilters.add(mapped.get());
                continue;
            }
            nonPartitionFilters.add(p);
        }
        if (partitionFilters.size() > 0) {
            this.scan.withPartitionFilter(PredicateBuilder.and(partitionFilters));
        }
        if (nonPartitionFilters.size() > 0) {
            this.withNonPartitionFilter(PredicateBuilder.and(nonPartitionFilters));
        }
        return this;
    }

    public TableScan withIncremental(boolean isIncremental) {
        this.isIncremental = isIncremental;
        this.scan.withIncremental(isIncremental);
        return this;
    }

    @VisibleForTesting
    public TableScan withBucket(int bucket) {
        this.scan.withBucket(bucket);
        return this;
    }

    public Plan plan() {
        FileStoreScan.Plan plan = this.scan.plan();
        return new Plan(plan.snapshotId(), this.generateSplits(plan.groupByPartFiles()));
    }

    private List<Split> generateSplits(Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupedDataFiles) {
        return TableScan.generateSplits(this.isIncremental, this.splitGenerator(this.pathFactory), groupedDataFiles);
    }

    @VisibleForTesting
    public static List<Split> generateSplits(boolean isIncremental, SplitGenerator splitGenerator, Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupedDataFiles) {
        ArrayList<Split> splits = new ArrayList<Split>();
        for (Map.Entry<BinaryRowData, Map<Integer, List<DataFileMeta>>> entry : groupedDataFiles.entrySet()) {
            BinaryRowData partition = entry.getKey();
            Map<Integer, List<DataFileMeta>> buckets = entry.getValue();
            for (Map.Entry<Integer, List<DataFileMeta>> bucketEntry : buckets.entrySet()) {
                int bucket = bucketEntry.getKey();
                if (isIncremental) {
                    splits.add(new Split(partition, bucket, bucketEntry.getValue(), true));
                    continue;
                }
                splitGenerator.split(bucketEntry.getValue()).stream().map(files -> new Split(partition, bucket, (List<DataFileMeta>)files, false)).forEach(splits::add);
            }
        }
        return splits;
    }

    protected abstract SplitGenerator splitGenerator(FileStorePathFactory var1);

    protected abstract void withNonPartitionFilter(Predicate var1);

    public static class Plan {
        @Nullable
        public final Long snapshotId;
        public final List<Split> splits;

        @VisibleForTesting
        public Plan(@Nullable Long snapshotId, List<Split> splits) {
            this.snapshotId = snapshotId;
            this.splits = splits;
        }
    }
}

