/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.connector.SystemCatalogTable;
import org.apache.flink.table.store.connector.TableStoreConnectorFactory;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.schema.SchemaChange;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.Table;

public class FlinkCatalog
extends AbstractCatalog {
    private final Catalog catalog;

    public FlinkCatalog(Catalog catalog, String name, String defaultDatabase) {
        super(name, defaultDatabase);
        this.catalog = catalog;
        try {
            this.catalog.createDatabase(defaultDatabase, true);
        }
        catch (Catalog.DatabaseAlreadyExistException databaseAlreadyExistException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    public Catalog catalog() {
        return this.catalog;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new TableStoreConnectorFactory(this.catalog.lockFactory().orElse(null)));
    }

    public List<String> listDatabases() throws CatalogException {
        return this.catalog.listDatabases();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.catalog.databaseExists(databaseName);
    }

    public CatalogDatabase getDatabase(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (this.databaseExists(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (database != null) {
            if (database.getProperties().size() > 0) {
                throw new UnsupportedOperationException("Create database with properties is unsupported.");
            }
            if (database.getDescription().isPresent() && !((String)database.getDescription().get()).equals("")) {
                throw new UnsupportedOperationException("Create database with description is unsupported.");
            }
        }
        try {
            this.catalog.createDatabase(name, ignoreIfExists);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new DatabaseAlreadyExistException(this.getName(), e.database());
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotEmptyException, DatabaseNotExistException, CatalogException {
        try {
            this.catalog.dropDatabase(name, ignoreIfNotExists, cascade);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new DatabaseNotEmptyException(this.getName(), e.database());
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalog.listTables(databaseName);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public CatalogTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Table table;
        try {
            table = this.catalog.getTable(tablePath);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), e.tablePath());
        }
        if (table instanceof FileStoreTable) {
            CatalogTableImpl catalogTable = ((FileStoreTable)table).schema().toUpdateSchema().toCatalogTable();
            catalogTable.getOptions().put(CoreOptions.PATH.key(), this.catalog.getTableLocation(tablePath).toString());
            return catalogTable;
        }
        return new SystemCatalogTable(table);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        return this.catalog.tableExists(tablePath);
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            this.catalog.dropTable(tablePath, ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), e.tablePath());
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        if (!(table instanceof CatalogTable)) {
            throw new UnsupportedOperationException("Only support CatalogTable, but is: " + table.getClass());
        }
        CatalogTable catalogTable = (CatalogTable)table;
        Map options = table.getOptions();
        if (options.containsKey(FactoryUtil.CONNECTOR.key())) {
            throw new CatalogException(String.format("Table Store Catalog only supports table store tables, not '%s' connector. You can create TEMPORARY table instead.", options.get(FactoryUtil.CONNECTOR.key())));
        }
        String specific = (String)options.remove(CoreOptions.PATH.key());
        if (specific != null) {
            catalogTable = catalogTable.copy(options);
        }
        try {
            this.catalog.createTable(tablePath, UpdateSchema.fromCatalogTable(catalogTable), ignoreIfExists);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistException(this.getName(), e.tablePath());
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        CatalogTable table = this.getTable(tablePath);
        FlinkCatalog.validateAlterTable(table, (CatalogTable)newTable);
        ArrayList<SchemaChange> changes = new ArrayList<SchemaChange>();
        Map oldProperties = table.getOptions();
        for (Map.Entry entry : newTable.getOptions().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (Objects.equals(value, oldProperties.get(key))) continue;
            if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
                throw new IllegalArgumentException("Illegal table path in table options: " + value);
            }
            changes.add(SchemaChange.setOption(key, value));
        }
        oldProperties.keySet().forEach(k -> {
            if (!newTable.getOptions().containsKey(k)) {
                changes.add(SchemaChange.removeOption(k));
            }
        });
        try {
            this.catalog.alterTable(tablePath, changes, ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), e.tablePath());
        }
    }

    private static void validateAlterTable(CatalogTable ct1, CatalogTable ct2) {
        TableSchema ts1 = ct1.getSchema();
        TableSchema ts2 = ct2.getSchema();
        boolean pkEquality = false;
        if (ts1.getPrimaryKey().isPresent() && ts2.getPrimaryKey().isPresent()) {
            pkEquality = Objects.equals(((UniqueConstraint)ts1.getPrimaryKey().get()).getType(), ((UniqueConstraint)ts2.getPrimaryKey().get()).getType()) && Objects.equals(((UniqueConstraint)ts1.getPrimaryKey().get()).getColumns(), ((UniqueConstraint)ts2.getPrimaryKey().get()).getColumns());
        } else if (!ts1.getPrimaryKey().isPresent() && !ts2.getPrimaryKey().isPresent()) {
            pkEquality = true;
        }
        if (!(Objects.equals(ts1.getTableColumns(), ts2.getTableColumns()) && Objects.equals(ts1.getWatermarkSpecs(), ts2.getWatermarkSpecs()) && pkEquality)) {
            throw new UnsupportedOperationException("Altering schema is not supported yet.");
        }
        if (!ct1.getPartitionKeys().equals(ct2.getPartitionKeys())) {
            throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
        }
    }

    public final void open() throws CatalogException {
    }

    public final void close() throws CatalogException {
        try {
            this.catalog.close();
        }
        catch (Exception e) {
            throw new CatalogException("Failed to close catalog " + this.catalog.toString(), (Throwable)e);
        }
    }

    public final void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final List<String> listViews(String databaseName) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public final boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public final void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final List<String> listFunctions(String dbName) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public final boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public final void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }
}

