/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.sink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class TransactionsToAbortChecker {
    private static final int MINIMUM_CHECKPOINT_OFFSET = 1;
    private final int numberOfParallelSubtasks;
    private final Map<Integer, Long> subtaskIdCheckpointOffsetMapping;
    private final int subtaskId;

    TransactionsToAbortChecker(int numberOfParallelSubtasks, Map<Integer, Long> subtaskIdCheckpointOffsetMapping, int subtaskId) {
        this.subtaskId = subtaskId;
        this.numberOfParallelSubtasks = numberOfParallelSubtasks;
        this.subtaskIdCheckpointOffsetMapping = subtaskIdCheckpointOffsetMapping;
    }

    public List<String> getTransactionsToAbort(Map<Integer, Map<Long, String>> openTransactions) {
        ArrayList<String> transactionalIdsToAbort = new ArrayList<String>();
        for (Map.Entry<Integer, Map<Long, String>> subtaskOffsetMapping : openTransactions.entrySet()) {
            Map<Long, String> checkpointOffsetTransactionalIdMapping = subtaskOffsetMapping.getValue();
            if (checkpointOffsetTransactionalIdMapping.isEmpty()) continue;
            if (Collections.min(checkpointOffsetTransactionalIdMapping.keySet()) == 1L && subtaskOffsetMapping.getKey() % this.numberOfParallelSubtasks == this.subtaskId) {
                transactionalIdsToAbort.addAll(checkpointOffsetTransactionalIdMapping.values());
                continue;
            }
            for (Map.Entry<Long, String> offsetTransactionId : checkpointOffsetTransactionalIdMapping.entrySet()) {
                if (!this.hasSameSubtaskWithHigherCheckpoint(subtaskOffsetMapping.getKey(), offsetTransactionId.getKey())) continue;
                transactionalIdsToAbort.add(offsetTransactionId.getValue());
            }
        }
        return transactionalIdsToAbort;
    }

    private boolean hasSameSubtaskWithHigherCheckpoint(int openSubtaskIndex, long openCheckpointOffset) {
        return this.subtaskIdCheckpointOffsetMapping.containsKey(openSubtaskIndex) && this.subtaskIdCheckpointOffsetMapping.get(openSubtaskIndex) <= openCheckpointOffset;
    }
}

