/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.store.file.WriteMode;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.util.Preconditions;

public class CoreOptions
implements Serializable {
    public static final ConfigOption<Integer> BUCKET = ConfigOptions.key((String)"bucket").intType().defaultValue((Object)1).withDescription("Bucket number for file store.");
    @Immutable
    public static final ConfigOption<String> BUCKET_KEY = ConfigOptions.key((String)"bucket-key").stringType().noDefaultValue().withDescription(Description.builder().text("Specify the table store distribution policy. Data is assigned to each bucket according to the hash value of bucket-key.").linebreak().text("If you specify multiple fields, delimiter is ','.").linebreak().text("If not specified, the primary key will be used; if there is no primary key, the full row will be used.").build());
    @Documentation.ExcludeFromDocumentation(value="Internal use only")
    @Internal
    public static final ConfigOption<String> PATH = ConfigOptions.key((String)"path").stringType().noDefaultValue().withDescription("The file path of this table in the filesystem.");
    public static final ConfigOption<String> FILE_FORMAT = ConfigOptions.key((String)"file.format").stringType().defaultValue((Object)"orc").withDescription("Specify the message format of data files.");
    public static final ConfigOption<String> MANIFEST_FORMAT = ConfigOptions.key((String)"manifest.format").stringType().defaultValue((Object)"avro").withDescription("Specify the message format of manifest files.");
    public static final ConfigOption<MemorySize> MANIFEST_TARGET_FILE_SIZE = ConfigOptions.key((String)"manifest.target-file-size").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)8L)).withDescription("Suggested file size of a manifest file.");
    public static final ConfigOption<Integer> MANIFEST_MERGE_MIN_COUNT = ConfigOptions.key((String)"manifest.merge-min-count").intType().defaultValue((Object)30).withDescription("To avoid frequent manifest merges, this parameter specifies the minimum number of ManifestFileMeta to merge.");
    public static final ConfigOption<String> PARTITION_DEFAULT_NAME = ConfigOptions.key((String)"partition.default-name").stringType().defaultValue((Object)"__DEFAULT_PARTITION__").withDescription("The default partition name in case the dynamic partition column value is null/empty string.");
    public static final ConfigOption<Integer> SNAPSHOT_NUM_RETAINED_MIN = ConfigOptions.key((String)"snapshot.num-retained.min").intType().defaultValue((Object)10).withDescription("The minimum number of completed snapshots to retain.");
    public static final ConfigOption<Integer> SNAPSHOT_NUM_RETAINED_MAX = ConfigOptions.key((String)"snapshot.num-retained.max").intType().defaultValue((Object)Integer.MAX_VALUE).withDescription("The maximum number of completed snapshots to retain.");
    public static final ConfigOption<Duration> SNAPSHOT_TIME_RETAINED = ConfigOptions.key((String)"snapshot.time-retained").durationType().defaultValue((Object)Duration.ofHours(1L)).withDescription("The maximum time of completed snapshots to retain.");
    public static final ConfigOption<Duration> CONTINUOUS_DISCOVERY_INTERVAL = ConfigOptions.key((String)"continuous.discovery-interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("The discovery interval of continuous reading.");
    @Immutable
    public static final ConfigOption<MergeEngine> MERGE_ENGINE = ConfigOptions.key((String)"merge-engine").enumType(MergeEngine.class).defaultValue((Object)MergeEngine.DEDUPLICATE).withDescription("Specify the merge engine for table with primary key.");
    public static final ConfigOption<Boolean> PARTIAL_UPDATE_IGNORE_DELETE = ConfigOptions.key((String)"partial-update.ignore-delete").booleanType().defaultValue((Object)false).withDescription("Whether to ignore delete records in partial-update mode.");
    @Immutable
    public static final ConfigOption<WriteMode> WRITE_MODE = ConfigOptions.key((String)"write-mode").enumType(WriteMode.class).defaultValue((Object)WriteMode.CHANGE_LOG).withDescription("Specify the write mode for table.");
    public static final ConfigOption<Boolean> WRITE_ONLY = ConfigOptions.key((String)"write-only").booleanType().defaultValue((Object)false).withDeprecatedKeys(new String[]{"write.compaction-skip"}).withDescription("If set to true, compactions and snapshot expiration will be skipped. This option is used along with dedicated compact jobs.");
    public static final ConfigOption<MemorySize> SOURCE_SPLIT_TARGET_SIZE = ConfigOptions.key((String)"source.split.target-size").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)128L)).withDescription("Target size of a source split when scanning a bucket.");
    public static final ConfigOption<MemorySize> SOURCE_SPLIT_OPEN_FILE_COST = ConfigOptions.key((String)"source.split.open-file-cost").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)4L)).withDescription("Open file cost of a source file. It is used to avoid reading too many files with a source split, which can be very slow.");
    public static final ConfigOption<MemorySize> WRITE_BUFFER_SIZE = ConfigOptions.key((String)"write-buffer-size").memoryType().defaultValue((Object)MemorySize.parse((String)"256 mb")).withDescription("Amount of data to build up in memory before converting to a sorted on-disk file.");
    public static final ConfigOption<Boolean> WRITE_BUFFER_SPILLABLE = ConfigOptions.key((String)"write-buffer-spillable").booleanType().noDefaultValue().withDescription("Whether the write buffer can be spillable. Enabled by default when using object storage.");
    public static final ConfigOption<Integer> LOCAL_SORT_MAX_NUM_FILE_HANDLES = ConfigOptions.key((String)"local-sort.max-num-file-handles").intType().defaultValue((Object)128).withDescription("The maximal fan-in for external merge sort. It limits the number of file handles. If it is too small, may cause intermediate merging. But if it is too large, it will cause too many files opened at the same time, consume memory and lead to random reading.");
    public static final ConfigOption<MemorySize> PAGE_SIZE = ConfigOptions.key((String)"page-size").memoryType().defaultValue((Object)MemorySize.parse((String)"64 kb")).withDescription("Memory page size.");
    public static final ConfigOption<MemorySize> TARGET_FILE_SIZE = ConfigOptions.key((String)"target-file-size").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)128L)).withDescription("Target size of a file.");
    public static final ConfigOption<Integer> NUM_SORTED_RUNS_COMPACTION_TRIGGER = ConfigOptions.key((String)"num-sorted-run.compaction-trigger").intType().defaultValue((Object)5).withDescription("The sorted run number to trigger compaction. Includes level0 files (one file one sorted run) and high-level runs (one level one sorted run).");
    public static final ConfigOption<Integer> NUM_SORTED_RUNS_STOP_TRIGGER = ConfigOptions.key((String)"num-sorted-run.stop-trigger").intType().noDefaultValue().withDescription("The number of sorted runs that trigger the stopping of writes, the default value is 'num-sorted-run.compaction-trigger' + 1.");
    public static final ConfigOption<Integer> NUM_LEVELS = ConfigOptions.key((String)"num-levels").intType().noDefaultValue().withDescription("Total level number, for example, there are 3 levels, including 0,1,2 levels.");
    public static final ConfigOption<Boolean> COMMIT_FORCE_COMPACT = ConfigOptions.key((String)"commit.force-compact").booleanType().defaultValue((Object)false).withDescription("Whether to force a compaction before commit.");
    public static final ConfigOption<Integer> COMPACTION_MAX_SIZE_AMPLIFICATION_PERCENT = ConfigOptions.key((String)"compaction.max-size-amplification-percent").intType().defaultValue((Object)200).withDescription("The size amplification is defined as the amount (in percentage) of additional storage needed to store a single byte of data in the merge tree for changelog mode table.");
    public static final ConfigOption<Integer> COMPACTION_SIZE_RATIO = ConfigOptions.key((String)"compaction.size-ratio").intType().defaultValue((Object)1).withDescription("Percentage flexibility while comparing sorted run size for changelog mode table. If the candidate sorted run(s) size is 1% smaller than the next sorted run's size, then include next sorted run into this candidate set.");
    public static final ConfigOption<Integer> COMPACTION_MIN_FILE_NUM = ConfigOptions.key((String)"compaction.min.file-num").intType().defaultValue((Object)5).withDescription("For file set [f_0,...,f_N], the minimum file number which satisfies sum(size(f_i)) >= targetFileSize to trigger a compaction for append-only table. This value avoids almost-full-file to be compacted, which is not cost-effective.");
    public static final ConfigOption<Integer> COMPACTION_MAX_FILE_NUM = ConfigOptions.key((String)"compaction.early-max.file-num").intType().defaultValue((Object)50).withDescription("For file set [f_0,...,f_N], the maximum file number to trigger a compaction for append-only table, even if sum(size(f_i)) < targetFileSize. This value avoids pending too much small files, which slows down the performance.");
    public static final ConfigOption<Integer> COMPACTION_MAX_SORTED_RUN_NUM = ConfigOptions.key((String)"compaction.max-sorted-run-num").intType().defaultValue((Object)Integer.MAX_VALUE).withDescription("The maximum sorted run number to pick for compaction. This value avoids merging too much sorted runs at the same time during compaction, which may lead to OutOfMemoryError.");
    public static final ConfigOption<ChangelogProducer> CHANGELOG_PRODUCER = ConfigOptions.key((String)"changelog-producer").enumType(ChangelogProducer.class).defaultValue((Object)ChangelogProducer.NONE).withDescription("Whether to double write to a changelog file. This changelog file keeps the details of data changes, it can be read directly during stream reads.");
    public static final ConfigOption<Duration> CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL = ConfigOptions.key((String)"changelog-producer.compaction-interval").durationType().defaultValue((Object)Duration.ofMinutes(30L)).withDescription("When " + CHANGELOG_PRODUCER.key() + " is set to " + ChangelogProducer.FULL_COMPACTION.name() + ", full compaction will be constantly triggered after this interval.");
    @Immutable
    public static final ConfigOption<String> SEQUENCE_FIELD = ConfigOptions.key((String)"sequence.field").stringType().noDefaultValue().withDescription("The field that generates the sequence number for primary key table, the sequence number determines which data is the most recent.");
    public static final ConfigOption<StartupMode> SCAN_MODE = ConfigOptions.key((String)"scan.mode").enumType(StartupMode.class).defaultValue((Object)StartupMode.DEFAULT).withDeprecatedKeys(new String[]{"log.scan"}).withDescription("Specify the scanning behavior of the source.");
    public static final ConfigOption<Long> SCAN_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.timestamp-millis").longType().noDefaultValue().withDeprecatedKeys(new String[]{"log.scan.timestamp-millis"}).withDescription("Optional timestamp used in case of \"from-timestamp\" scan mode.");
    public static final ConfigOption<Long> SCAN_SNAPSHOT_ID = ConfigOptions.key((String)"scan.snapshot-id").longType().noDefaultValue().withDescription("Optional snapshot id used in case of \"from-snapshot\" scan mode");
    public static final ConfigOption<Duration> LOG_RETENTION = ConfigOptions.key((String)"log.retention").durationType().noDefaultValue().withDescription("It means how long changes log will be kept. The default value is from the log system cluster.");
    public static final ConfigOption<LogConsistency> LOG_CONSISTENCY = ConfigOptions.key((String)"log.consistency").enumType(LogConsistency.class).defaultValue((Object)LogConsistency.TRANSACTIONAL).withDescription("Specify the log consistency mode for table.");
    public static final ConfigOption<LogChangelogMode> LOG_CHANGELOG_MODE = ConfigOptions.key((String)"log.changelog-mode").enumType(LogChangelogMode.class).defaultValue((Object)LogChangelogMode.AUTO).withDescription("Specify the log changelog mode for table.");
    public static final ConfigOption<Boolean> LOG_SCAN_REMOVE_NORMALIZE = ConfigOptions.key((String)"log.scan.remove-normalize").booleanType().defaultValue((Object)false).withDescription("Whether to force the removal of the normalize node when streaming read. Note: This is dangerous and is likely to cause data errors if downstream is used to calculate aggregation and the input is not complete changelog.");
    public static final ConfigOption<String> LOG_KEY_FORMAT = ConfigOptions.key((String)"log.key.format").stringType().defaultValue((Object)"json").withDescription("Specify the key message format of log system with primary key.");
    public static final ConfigOption<String> LOG_FORMAT = ConfigOptions.key((String)"log.format").stringType().defaultValue((Object)"debezium-json").withDescription("Specify the message format of log system.");
    public static final ConfigOption<Boolean> AUTO_CREATE = ConfigOptions.key((String)"auto-create").booleanType().defaultValue((Object)false).withDescription("Whether to create underlying storage when reading and writing the table.");
    private final Configuration options;

    public CoreOptions(Map<String, String> options) {
        this(Configuration.fromMap(options));
    }

    public CoreOptions(Configuration options) {
        this.options = options;
    }

    public Map<String, String> toMap() {
        return this.options.toMap();
    }

    public int bucket() {
        return (Integer)this.options.get(BUCKET);
    }

    public Path path() {
        return CoreOptions.path(this.options.toMap());
    }

    public static Path path(Map<String, String> options) {
        return new Path(options.get(PATH.key()));
    }

    public static Path path(Configuration options) {
        return new Path((String)options.get(PATH));
    }

    public FileFormat fileFormat() {
        return FileFormat.fromTableOptions(this.options, FILE_FORMAT);
    }

    public FileFormat manifestFormat() {
        return FileFormat.fromTableOptions(this.options, MANIFEST_FORMAT);
    }

    public MemorySize manifestTargetSize() {
        return (MemorySize)this.options.get(MANIFEST_TARGET_FILE_SIZE);
    }

    public String partitionDefaultName() {
        return (String)this.options.get(PARTITION_DEFAULT_NAME);
    }

    public int snapshotNumRetainMin() {
        return (Integer)this.options.get(SNAPSHOT_NUM_RETAINED_MIN);
    }

    public int snapshotNumRetainMax() {
        return (Integer)this.options.get(SNAPSHOT_NUM_RETAINED_MAX);
    }

    public Duration snapshotTimeRetain() {
        return (Duration)this.options.get(SNAPSHOT_TIME_RETAINED);
    }

    public int manifestMergeMinCount() {
        return (Integer)this.options.get(MANIFEST_MERGE_MIN_COUNT);
    }

    public MergeEngine mergeEngine() {
        return (MergeEngine)((Object)this.options.get(MERGE_ENGINE));
    }

    public long splitTargetSize() {
        return ((MemorySize)this.options.get(SOURCE_SPLIT_TARGET_SIZE)).getBytes();
    }

    public long splitOpenFileCost() {
        return ((MemorySize)this.options.get(SOURCE_SPLIT_OPEN_FILE_COST)).getBytes();
    }

    public long writeBufferSize() {
        return ((MemorySize)this.options.get(WRITE_BUFFER_SIZE)).getBytes();
    }

    public boolean writeBufferSpillable(boolean usingObjectStore) {
        return this.options.getOptional(WRITE_BUFFER_SPILLABLE).orElse(usingObjectStore);
    }

    public Duration continuousDiscoveryInterval() {
        return (Duration)this.options.get(CONTINUOUS_DISCOVERY_INTERVAL);
    }

    public int localSortMaxNumFileHandles() {
        return (Integer)this.options.get(LOCAL_SORT_MAX_NUM_FILE_HANDLES);
    }

    public int pageSize() {
        return (int)((MemorySize)this.options.get(PAGE_SIZE)).getBytes();
    }

    public long targetFileSize() {
        return ((MemorySize)this.options.get(TARGET_FILE_SIZE)).getBytes();
    }

    public int numSortedRunCompactionTrigger() {
        return (Integer)this.options.get(NUM_SORTED_RUNS_COMPACTION_TRIGGER);
    }

    public int numSortedRunStopTrigger() {
        Integer stopTrigger = (Integer)this.options.get(NUM_SORTED_RUNS_STOP_TRIGGER);
        if (stopTrigger == null) {
            stopTrigger = this.numSortedRunCompactionTrigger() + 1;
        }
        return Math.max(this.numSortedRunCompactionTrigger(), stopTrigger);
    }

    public int numLevels() {
        Integer numLevels = (Integer)this.options.get(NUM_LEVELS);
        int expectedRuns = this.maxSortedRunNum() == Integer.MAX_VALUE ? this.numSortedRunCompactionTrigger() : this.numSortedRunStopTrigger();
        numLevels = numLevels == null ? expectedRuns + 1 : numLevels;
        return numLevels;
    }

    public boolean commitForceCompact() {
        return (Boolean)this.options.get(COMMIT_FORCE_COMPACT);
    }

    public int maxSizeAmplificationPercent() {
        return (Integer)this.options.get(COMPACTION_MAX_SIZE_AMPLIFICATION_PERCENT);
    }

    public int sortedRunSizeRatio() {
        return (Integer)this.options.get(COMPACTION_SIZE_RATIO);
    }

    public int compactionMinFileNum() {
        return (Integer)this.options.get(COMPACTION_MIN_FILE_NUM);
    }

    public int compactionMaxFileNum() {
        return (Integer)this.options.get(COMPACTION_MAX_FILE_NUM);
    }

    public int maxSortedRunNum() {
        return (Integer)this.options.get(COMPACTION_MAX_SORTED_RUN_NUM);
    }

    public ChangelogProducer changelogProducer() {
        return (ChangelogProducer)((Object)this.options.get(CHANGELOG_PRODUCER));
    }

    public StartupMode startupMode() {
        return CoreOptions.startupMode((ReadableConfig)this.options);
    }

    public static StartupMode startupMode(ReadableConfig options) {
        StartupMode mode = (StartupMode)((Object)options.get(SCAN_MODE));
        if (mode == StartupMode.DEFAULT) {
            if (options.getOptional(SCAN_TIMESTAMP_MILLIS).isPresent()) {
                return StartupMode.FROM_TIMESTAMP;
            }
            if (options.getOptional(SCAN_SNAPSHOT_ID).isPresent()) {
                return StartupMode.FROM_SNAPSHOT;
            }
            return StartupMode.LATEST_FULL;
        }
        if (mode == StartupMode.FULL) {
            return StartupMode.LATEST_FULL;
        }
        return mode;
    }

    public Long scanTimestampMills() {
        return (Long)this.options.get(SCAN_TIMESTAMP_MILLIS);
    }

    public Long scanSnapshotId() {
        return (Long)this.options.get(SCAN_SNAPSHOT_ID);
    }

    public Duration changelogProducerFullCompactionTriggerInterval() {
        return (Duration)this.options.get(CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL);
    }

    public Optional<String> sequenceField() {
        return this.options.getOptional(SEQUENCE_FIELD);
    }

    public WriteMode writeMode() {
        return (WriteMode)((Object)this.options.get(WRITE_MODE));
    }

    public boolean writeOnly() {
        return (Boolean)this.options.get(WRITE_ONLY);
    }

    public static void setDefaultValues(Configuration options) {
        if (options.contains(SCAN_TIMESTAMP_MILLIS) && !options.contains(SCAN_MODE)) {
            options.set(SCAN_MODE, (Object)StartupMode.FROM_TIMESTAMP);
        }
    }

    public static void validateTableSchema(TableSchema schema) {
        CoreOptions options = new CoreOptions(schema.options());
        if (options.startupMode() == StartupMode.FROM_TIMESTAMP) {
            CoreOptions.checkOptionExistInMode(options, SCAN_TIMESTAMP_MILLIS, StartupMode.FROM_TIMESTAMP);
            CoreOptions.checkOptionsConflict(options, SCAN_SNAPSHOT_ID, SCAN_TIMESTAMP_MILLIS);
        } else if (options.startupMode() == StartupMode.FROM_SNAPSHOT) {
            CoreOptions.checkOptionExistInMode(options, SCAN_SNAPSHOT_ID, StartupMode.FROM_SNAPSHOT);
            CoreOptions.checkOptionsConflict(options, SCAN_TIMESTAMP_MILLIS, SCAN_SNAPSHOT_ID);
        } else {
            CoreOptions.checkOptionNotExistInMode(options, SCAN_TIMESTAMP_MILLIS, options.startupMode());
            CoreOptions.checkOptionNotExistInMode(options, SCAN_SNAPSHOT_ID, options.startupMode());
        }
        Preconditions.checkArgument((options.snapshotNumRetainMin() > 0 ? 1 : 0) != 0, (Object)(SNAPSHOT_NUM_RETAINED_MIN.key() + " should be at least 1"));
        Preconditions.checkArgument((options.snapshotNumRetainMin() <= options.snapshotNumRetainMax() ? 1 : 0) != 0, (Object)(SNAPSHOT_NUM_RETAINED_MIN.key() + " should not be larger than " + SNAPSHOT_NUM_RETAINED_MAX.key()));
        if (options.changelogProducer() == ChangelogProducer.FULL_COMPACTION && options.writeMode() == WriteMode.CHANGE_LOG && schema.primaryKeys().isEmpty()) {
            throw new UnsupportedOperationException("Changelog table with full compaction must have primary keys");
        }
        schema.fieldNames().forEach(f -> {
            Preconditions.checkState((!TableSchema.SYSTEM_FIELD_NAMES.contains(f) ? 1 : 0) != 0, (Object)String.format("Field name[%s] in schema cannot be exist in [%s]", f, TableSchema.SYSTEM_FIELD_NAMES.toString()));
            Preconditions.checkState((!f.startsWith("_KEY_") ? 1 : 0) != 0, (Object)String.format("Field name[%s] in schema cannot start with [%s]", f, "_KEY_"));
        });
        if (!schema.primaryKeys().isEmpty() && Objects.equals((Object)WriteMode.APPEND_ONLY, (Object)options.writeMode())) {
            throw new TableException("Cannot define any primary key in an append-only table. Set 'write-mode'='change-log' if still want to keep the primary key definition.");
        }
    }

    private static void checkOptionExistInMode(CoreOptions options, ConfigOption<?> option, StartupMode startupMode) {
        Preconditions.checkArgument((boolean)options.options.contains(option), (Object)String.format("%s can not be null when you use %s for %s", new Object[]{option.key(), startupMode, SCAN_MODE.key()}));
    }

    private static void checkOptionNotExistInMode(CoreOptions options, ConfigOption<?> option, StartupMode startupMode) {
        Preconditions.checkArgument((!options.options.contains(option) ? 1 : 0) != 0, (Object)String.format("%s must be null when you use %s for %s", new Object[]{option.key(), startupMode, SCAN_MODE.key()}));
    }

    private static void checkOptionsConflict(CoreOptions options, ConfigOption<?> illegalOption, ConfigOption<?> legalOption) {
        Preconditions.checkArgument((!options.options.contains(illegalOption) ? 1 : 0) != 0, (Object)String.format("%s must be null when you set %s", illegalOption.key(), legalOption.key()));
    }

    @Internal
    public static List<ConfigOption<?>> getOptions() {
        Field[] fields = CoreOptions.class.getFields();
        ArrayList list = new ArrayList(fields.length);
        for (Field field : fields) {
            if (!ConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                list.add((ConfigOption)field.get(CoreOptions.class));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    @Internal
    public static Set<String> getImmutableOptionKeys() {
        Field[] fields = CoreOptions.class.getFields();
        HashSet<String> immutableKeys = new HashSet<String>(fields.length);
        for (Field field : fields) {
            if (!ConfigOption.class.isAssignableFrom(field.getType()) || field.getAnnotation(Immutable.class) == null) continue;
            try {
                immutableKeys.add(((ConfigOption)field.get(CoreOptions.class)).key());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return immutableKeys;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Internal
    public static @interface Immutable {
    }

    public static enum ChangelogProducer implements DescribedEnum
    {
        NONE("none", "No changelog file."),
        INPUT("input", "Double write to a changelog file when flushing memory table, the changelog is from input."),
        FULL_COMPACTION("full-compaction", "Generate changelog files with each full compaction.");

        private final String value;
        private final String description;

        private ChangelogProducer(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }

    public static enum LogChangelogMode implements DescribedEnum
    {
        AUTO("auto", "Upsert for table with primary key, all for table without primary key."),
        ALL("all", "The log system stores all changes including UPDATE_BEFORE."),
        UPSERT("upsert", "The log system does not store the UPDATE_BEFORE changes, the log consumed job will automatically add the normalized node, relying on the state to generate the required update_before.");

        private final String value;
        private final String description;

        private LogChangelogMode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }

    public static enum LogConsistency implements DescribedEnum
    {
        TRANSACTIONAL("transactional", "Only the data after the checkpoint can be seen by readers, the latency depends on checkpoint interval."),
        EVENTUAL("eventual", "Immediate data visibility, you may see some intermediate states, but eventually the right results will be produced, only works for table with primary key.");

        private final String value;
        private final String description;

        private LogConsistency(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }

    public static enum StartupMode implements DescribedEnum
    {
        DEFAULT("default", "Determines actual startup mode according to other table properties. If \"scan.timestamp-millis\" is set the actual startup mode will be \"from-timestamp\", and if \"scan.snapshot-id\" is set the actual startup mode will be \"from-snapshot\". Otherwise the actual startup mode will be \"latest-full\"."),
        LATEST_FULL("latest-full", "For streaming sources, produces the latest snapshot on the table upon first startup, and continue to read the latest changes. For batch sources, just produce the latest snapshot but does not read new changes."),
        FULL("full", "Deprecated. Same as \"latest-full\"."),
        LATEST("latest", "For streaming sources, continuously reads latest changes without producing a snapshot at the beginning. For batch sources, behaves the same as the \"latest-full\" startup mode."),
        COMPACTED_FULL("compacted-full", "For streaming sources, produces a snapshot after the latest compaction on the table upon first startup, and continue to read the latest changes. For batch sources, just produce a snapshot after the latest compaction but does not read new changes."),
        FROM_TIMESTAMP("from-timestamp", "For streaming sources, continuously reads changes starting from timestamp specified by \"scan.timestamp-millis\", without producing a snapshot at the beginning. For batch sources, produces a snapshot at timestamp specified by \"scan.timestamp-millis\" but does not read new changes."),
        FROM_SNAPSHOT("from-snapshot", "For streaming sources, continuously reads changes starting from snapshot specified by \"scan.snapshot-id\", without producing a snapshot at the beginning. For batch sources, produces a snapshot specified by \"scan.snapshot-id\" but does not read new changes.");

        private final String value;
        private final String description;

        private StartupMode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }

    public static enum MergeEngine implements DescribedEnum
    {
        DEDUPLICATE("deduplicate", "De-duplicate and keep the last row."),
        PARTIAL_UPDATE("partial-update", "Partial update non-null fields."),
        AGGREGATE("aggregation", "Aggregate fields with same primary key.");

        private final String value;
        private final String description;

        private MergeEngine(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        public InlineElement getDescription() {
            return TextElement.text((String)this.description);
        }
    }
}

