/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.table.store.plugin.FileSystemLoader;

public class FileSystems {
    public static void initialize(Path path, Configuration configuration) {
        try {
            FileSystem fs = path.getFileSystem();
            fs.getFileStatus(path);
            return;
        }
        catch (IOException fs) {
            FileSystem.initialize((Configuration)configuration, (PluginManager)new PluginManager(){

                public <P> Iterator<P> load(Class<P> service) {
                    return FileSystems.discoverFactories().iterator();
                }
            });
            try {
                SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(configuration));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private static List<FileSystemFactory> discoverFactories() {
        ArrayList<FileSystemFactory> results = new ArrayList<FileSystemFactory>();
        ServiceLoader.load(FileSystemLoader.class, FileSystemLoader.class.getClassLoader()).iterator().forEachRemaining(loader -> results.add(loader.load()));
        return results;
    }
}

