/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import java.util.Collections;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.StartingScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousLatestStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousLatestStartingScanner.class);

    @Override
    public DataTableScan.DataFilePlan getPlan(SnapshotManager snapshotManager, DataTableScan scan) {
        Long startingSnapshotId = snapshotManager.latestSnapshotId();
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
            return null;
        }
        return new DataTableScan.DataFilePlan(startingSnapshotId, Collections.emptyList());
    }
}

