/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.util.Preconditions;

public final class PartitionableListState<S>
implements ListState<S> {
    private RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo;
    private final ArrayList<S> internalList;
    private ArrayListSerializer<S> internalListCopySerializer;

    PartitionableListState(RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo) {
        this(stateMetaInfo, new ArrayList());
    }

    private PartitionableListState(RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo, ArrayList<S> internalList) {
        this.stateMetaInfo = Preconditions.checkNotNull(stateMetaInfo);
        this.internalList = Preconditions.checkNotNull(internalList);
        this.internalListCopySerializer = new ArrayListSerializer<S>(stateMetaInfo.getPartitionStateSerializer());
    }

    private PartitionableListState(PartitionableListState<S> toCopy) {
        this(toCopy.stateMetaInfo.deepCopy(), toCopy.internalListCopySerializer.copy(toCopy.internalList));
    }

    public void setStateMetaInfo(RegisteredOperatorStateBackendMetaInfo<S> stateMetaInfo) {
        this.internalListCopySerializer = new ArrayListSerializer<S>(stateMetaInfo.getPartitionStateSerializer());
        this.stateMetaInfo = stateMetaInfo;
    }

    public RegisteredOperatorStateBackendMetaInfo<S> getStateMetaInfo() {
        return this.stateMetaInfo;
    }

    public PartitionableListState<S> deepCopy() {
        return new PartitionableListState<S>(this);
    }

    @Override
    public void clear() {
        this.internalList.clear();
    }

    @Override
    public Iterable<S> get() {
        return this.internalList;
    }

    @Override
    public void add(S value) {
        Preconditions.checkNotNull(value, "You cannot add null to a ListState.");
        this.internalList.add(value);
    }

    public String toString() {
        return "PartitionableListState{stateMetaInfo=" + this.stateMetaInfo + ", internalList=" + this.internalList + '}';
    }

    public long[] write(FSDataOutputStream out) throws IOException {
        long[] partitionOffsets = new long[this.internalList.size()];
        DataOutputViewStreamWrapper dov = new DataOutputViewStreamWrapper(out);
        for (int i = 0; i < this.internalList.size(); ++i) {
            S element = this.internalList.get(i);
            partitionOffsets[i] = out.getPos();
            this.getStateMetaInfo().getPartitionStateSerializer().serialize(element, dov);
        }
        return partitionOffsets;
    }

    @Override
    public void update(List<S> values) {
        this.internalList.clear();
        this.addAll(values);
    }

    @Override
    public void addAll(List<S> values) {
        if (values != null && !values.isEmpty()) {
            this.internalList.addAll(values);
        }
    }

    @VisibleForTesting
    public ArrayListSerializer<S> getInternalListCopySerializer() {
        return this.internalListCopySerializer;
    }
}

