/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long ALWAYS_FLUSH_BUFFER_TIMEOUT = 0L;
    private final String edgeId;
    private final int sourceId;
    private final int targetId;
    private final int uniqueId;
    private final int typeNumber;
    private final OutputTag outputTag;
    private StreamPartitioner<?> outputPartitioner;
    private final String sourceOperatorName;
    private final String targetOperatorName;
    private final StreamExchangeMode exchangeMode;
    private long bufferTimeout;
    private boolean supportsUnalignedCheckpoints = true;
    private final IntermediateDataSetID intermediateDatasetIdToProduce;

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, StreamPartitioner<?> outputPartitioner, OutputTag outputTag) {
        this(sourceVertex, targetVertex, typeNumber, 0L, outputPartitioner, outputTag, StreamExchangeMode.UNDEFINED, 0, null);
    }

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, StreamPartitioner<?> outputPartitioner, OutputTag outputTag, StreamExchangeMode exchangeMode, int uniqueId, IntermediateDataSetID intermediateDatasetId) {
        this(sourceVertex, targetVertex, typeNumber, sourceVertex.getBufferTimeout(), outputPartitioner, outputTag, exchangeMode, uniqueId, intermediateDatasetId);
    }

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, long bufferTimeout, StreamPartitioner<?> outputPartitioner, OutputTag outputTag, StreamExchangeMode exchangeMode, int uniqueId, IntermediateDataSetID intermediateDatasetId) {
        this.sourceId = sourceVertex.getId();
        this.targetId = targetVertex.getId();
        this.uniqueId = uniqueId;
        this.typeNumber = typeNumber;
        this.bufferTimeout = bufferTimeout;
        this.outputPartitioner = outputPartitioner;
        this.outputTag = outputTag;
        this.sourceOperatorName = sourceVertex.getOperatorName();
        this.targetOperatorName = targetVertex.getOperatorName();
        this.exchangeMode = Preconditions.checkNotNull(exchangeMode);
        this.intermediateDatasetIdToProduce = intermediateDatasetId;
        this.edgeId = sourceVertex + "_" + targetVertex + "_" + typeNumber + "_" + outputPartitioner + "_" + uniqueId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public OutputTag getOutputTag() {
        return this.outputTag;
    }

    public StreamPartitioner<?> getPartitioner() {
        return this.outputPartitioner;
    }

    public StreamExchangeMode getExchangeMode() {
        return this.exchangeMode;
    }

    public void setPartitioner(StreamPartitioner<?> partitioner) {
        this.outputPartitioner = partitioner;
    }

    public void setBufferTimeout(long bufferTimeout) {
        Preconditions.checkArgument(bufferTimeout >= -1L);
        this.bufferTimeout = bufferTimeout;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public void setSupportsUnalignedCheckpoints(boolean supportsUnalignedCheckpoints) {
        this.supportsUnalignedCheckpoints = supportsUnalignedCheckpoints;
    }

    public boolean supportsUnalignedCheckpoints() {
        return this.supportsUnalignedCheckpoints;
    }

    public int hashCode() {
        return Objects.hash(this.edgeId, this.outputTag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamEdge that = (StreamEdge)o;
        return Objects.equals(this.edgeId, that.edgeId) && Objects.equals(this.outputTag, that.outputTag);
    }

    public String toString() {
        return "(" + this.sourceOperatorName + "-" + this.sourceId + " -> " + this.targetOperatorName + "-" + this.targetId + ", typeNumber=" + this.typeNumber + ", outputPartitioner=" + this.outputPartitioner + ", exchangeMode=" + (Object)((Object)this.exchangeMode) + ", bufferTimeout=" + this.bufferTimeout + ", outputTag=" + this.outputTag + ", uniqueId=" + this.uniqueId + ')';
    }

    public IntermediateDataSetID getIntermediateDatasetIdToProduce() {
        return this.intermediateDatasetIdToProduce;
    }
}

