/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.utils.RecordReader;

public class RecordReaderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void forEachRemaining(RecordReader<T> reader, Consumer<? super T> action) throws IOException {
        try {
            RecordReader.RecordIterator<T> batch;
            while ((batch = reader.readBatch()) != null) {
                T record;
                while ((record = batch.next()) != null) {
                    action.accept(record);
                }
                batch.releaseBatch();
            }
        }
        finally {
            reader.close();
        }
    }

    public static <L, R> RecordReader<R> transform(final RecordReader<L> fromReader, final Function<L, R> function) {
        return new RecordReader<R>(){

            @Override
            @Nullable
            public RecordReader.RecordIterator<R> readBatch() throws IOException {
                RecordReader.RecordIterator iterator = fromReader.readBatch();
                if (iterator == null) {
                    return null;
                }
                return RecordReaderUtils.transform(iterator, function);
            }

            @Override
            public void close() throws IOException {
                fromReader.close();
            }
        };
    }

    public static <L, R> RecordReader.RecordIterator<R> transform(final RecordReader.RecordIterator<L> fromIterator, final Function<L, R> function) {
        return new RecordReader.RecordIterator<R>(){

            @Override
            @Nullable
            public R next() throws IOException {
                Object next = fromIterator.next();
                if (next == null) {
                    return null;
                }
                return function.apply(next);
            }

            @Override
            public void releaseBatch() {
                fromIterator.releaseBatch();
            }
        };
    }
}

