/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.codegen.CodeGenUtils;
import org.apache.flink.table.store.codegen.Projection;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.table.sink.BucketComputer;
import org.apache.flink.table.store.table.sink.SinkRecord;
import org.apache.flink.table.types.logical.RowType;

public class SinkRecordConverter {
    private final BucketComputer bucketComputer;
    private final Projection partProjection;
    private final Projection pkProjection;
    @Nullable
    private final Projection logPkProjection;

    public SinkRecordConverter(TableSchema tableSchema) {
        this(tableSchema.logicalRowType(), tableSchema.projection(tableSchema.partitionKeys()), tableSchema.projection(tableSchema.trimmedPrimaryKeys()), tableSchema.projection(tableSchema.primaryKeys()), new BucketComputer(tableSchema));
    }

    private SinkRecordConverter(RowType inputType, int[] partitions, int[] primaryKeys, int[] logPrimaryKeys, BucketComputer bucketComputer) {
        this.bucketComputer = bucketComputer;
        this.partProjection = CodeGenUtils.newProjection(inputType, partitions);
        this.pkProjection = CodeGenUtils.newProjection(inputType, primaryKeys);
        this.logPkProjection = Arrays.equals(primaryKeys, logPrimaryKeys) ? null : CodeGenUtils.newProjection(inputType, logPrimaryKeys);
    }

    public SinkRecord convert(RowData row) {
        BinaryRowData partition = this.partProjection.apply(row);
        BinaryRowData primaryKey = this.primaryKey(row);
        int bucket = this.bucketComputer.bucket(row, primaryKey);
        return new SinkRecord(partition, bucket, primaryKey, row);
    }

    public SinkRecord convertToLogSinkRecord(SinkRecord record) {
        if (this.logPkProjection == null) {
            return record;
        }
        BinaryRowData logPrimaryKey = this.logPrimaryKey(record.row());
        return new SinkRecord(record.partition(), record.bucket(), logPrimaryKey, record.row());
    }

    public int bucket(RowData row) {
        return this.bucketComputer.bucket(row);
    }

    private BinaryRowData primaryKey(RowData row) {
        return this.pkProjection.apply(row);
    }

    private BinaryRowData logPrimaryKey(RowData row) {
        assert (this.logPkProjection != null);
        return this.logPkProjection.apply(row);
    }
}

