/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.net.InetAddress;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ProducerDescriptor {
    private final ResourceID producerLocation;
    private final ExecutionAttemptID producerExecutionId;
    private final InetAddress address;
    private final int dataPort;

    @VisibleForTesting
    public ProducerDescriptor(ResourceID producerLocation, ExecutionAttemptID producerExecutionId, InetAddress address, int dataPort) {
        this.producerLocation = Preconditions.checkNotNull(producerLocation);
        this.producerExecutionId = Preconditions.checkNotNull(producerExecutionId);
        this.address = Preconditions.checkNotNull(address);
        this.dataPort = dataPort;
    }

    public ResourceID getProducerLocation() {
        return this.producerLocation;
    }

    public ExecutionAttemptID getProducerExecutionId() {
        return this.producerExecutionId;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public static ProducerDescriptor create(TaskManagerLocation producerLocation, ExecutionAttemptID attemptId) {
        return new ProducerDescriptor(producerLocation.getResourceID(), attemptId, producerLocation.address(), producerLocation.dataPort());
    }
}

