/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.HashSet;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.CalculatedQueryOperation;
import org.apache.flink.table.operations.JoinQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
final class JoinOperationFactory {
    private final EquiJoinExistsChecker equiJoinExistsChecker = new EquiJoinExistsChecker();

    JoinOperationFactory() {
    }

    QueryOperation create(QueryOperation left, QueryOperation right, JoinQueryOperation.JoinType joinType, ResolvedExpression condition, boolean correlated) {
        this.verifyConditionType(condition);
        this.validateNamesAmbiguity(left, right);
        this.validateCondition(right, joinType, condition, correlated);
        return new JoinQueryOperation(left, right, joinType, condition, correlated);
    }

    private void validateCondition(QueryOperation right, JoinQueryOperation.JoinType joinType, ResolvedExpression condition, boolean correlated) {
        boolean alwaysTrue = ExpressionUtils.extractValue(condition, Boolean.class).orElse(false);
        if (alwaysTrue) {
            return;
        }
        Boolean equiJoinExists = condition.accept(this.equiJoinExistsChecker);
        if (correlated && right instanceof CalculatedQueryOperation && joinType != JoinQueryOperation.JoinType.INNER) {
            throw new ValidationException("Predicate for lateral left outer join with table function can only be empty or literal true.");
        }
        if (!equiJoinExists.booleanValue()) {
            throw new ValidationException(String.format("Invalid join condition: %s. At least one equi-join predicate is required.", condition));
        }
    }

    private void verifyConditionType(ResolvedExpression condition) {
        DataType conditionType = condition.getOutputDataType();
        LogicalType logicalType = conditionType.getLogicalType();
        if (!logicalType.is(LogicalTypeRoot.BOOLEAN)) {
            throw new ValidationException(String.format("Filter operator requires a boolean expression as input, but %s is of type %s", condition, conditionType));
        }
    }

    private void validateNamesAmbiguity(QueryOperation left, QueryOperation right) {
        HashSet<String> leftNames = new HashSet<String>(left.getResolvedSchema().getColumnNames());
        HashSet<String> rightNames = new HashSet<String>(right.getResolvedSchema().getColumnNames());
        leftNames.retainAll(rightNames);
        if (!leftNames.isEmpty()) {
            throw new ValidationException(String.format("join relations with ambiguous names: %s", leftNames));
        }
    }

    private boolean isJoinCondition(ResolvedExpression left, ResolvedExpression right) {
        if (left instanceof FieldReferenceExpression && right instanceof FieldReferenceExpression) {
            return ((FieldReferenceExpression)left).getInputIndex() != ((FieldReferenceExpression)right).getInputIndex();
        }
        return false;
    }

    private class EquiJoinExistsChecker
    extends ResolvedExpressionDefaultVisitor<Boolean> {
        private EquiJoinExistsChecker() {
        }

        @Override
        public Boolean visit(CallExpression call) {
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.EQUALS) {
                return JoinOperationFactory.this.isJoinCondition(call.getResolvedChildren().get(0), call.getResolvedChildren().get(1));
            }
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.OR) {
                return false;
            }
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.AND) {
                return call.getChildren().get(0).accept(this) != false || call.getChildren().get(1).accept(this) != false;
            }
            return false;
        }

        @Override
        protected Boolean defaultMethod(ResolvedExpression expression) {
            return false;
        }
    }
}

