/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.stats.BinaryTableStats;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;

public class ManifestFileMeta {
    private final String fileName;
    private final long fileSize;
    private final long numAddedFiles;
    private final long numDeletedFiles;
    private final BinaryTableStats partitionStats;
    private final long schemaId;

    public ManifestFileMeta(String fileName, long fileSize, long numAddedFiles, long numDeletedFiles, BinaryTableStats partitionStats, long schemaId) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.numAddedFiles = numAddedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.partitionStats = partitionStats;
        this.schemaId = schemaId;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long numAddedFiles() {
        return this.numAddedFiles;
    }

    public long numDeletedFiles() {
        return this.numDeletedFiles;
    }

    public BinaryTableStats partitionStats() {
        return this.partitionStats;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public static RowType schema() {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fields.add(new RowType.RowField("_FILE_NAME", new VarCharType(false, Integer.MAX_VALUE)));
        fields.add(new RowType.RowField("_FILE_SIZE", new BigIntType(false)));
        fields.add(new RowType.RowField("_NUM_ADDED_FILES", new BigIntType(false)));
        fields.add(new RowType.RowField("_NUM_DELETED_FILES", new BigIntType(false)));
        fields.add(new RowType.RowField("_PARTITION_STATS", FieldStatsArraySerializer.schema()));
        fields.add(new RowType.RowField("_SCHEMA_ID", new BigIntType(false)));
        return new RowType(fields);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestFileMeta)) {
            return false;
        }
        ManifestFileMeta that = (ManifestFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.numAddedFiles == that.numAddedFiles && this.numDeletedFiles == that.numDeletedFiles && Objects.equals(this.partitionStats, that.partitionStats) && this.schemaId == that.schemaId;
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId);
    }

    public String toString() {
        return String.format("{%s, %d, %d, %d, %s, %d}", this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId);
    }

    public static List<ManifestFileMeta> merge(List<ManifestFileMeta> metas, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        ArrayList<ManifestFileMeta> newMetas = new ArrayList<ManifestFileMeta>();
        ArrayList<ManifestFileMeta> candidates = new ArrayList<ManifestFileMeta>();
        long totalSize = 0L;
        try {
            for (ManifestFileMeta manifest : metas) {
                candidates.add(manifest);
                if ((totalSize += manifest.fileSize) < suggestedMetaSize) continue;
                ManifestFileMeta.mergeCandidates(candidates, manifestFile, result, newMetas);
                candidates.clear();
                totalSize = 0L;
            }
            if (candidates.size() >= suggestedMinMetaCount) {
                ManifestFileMeta.mergeCandidates(candidates, manifestFile, result, newMetas);
            } else {
                result.addAll(candidates);
            }
        }
        catch (Throwable e) {
            for (ManifestFileMeta manifest : newMetas) {
                manifestFile.delete(manifest.fileName);
            }
            throw e;
        }
        return result;
    }

    private static void mergeCandidates(List<ManifestFileMeta> candidates, ManifestFile manifestFile, List<ManifestFileMeta> result, List<ManifestFileMeta> newMetas) {
        if (candidates.size() == 1) {
            result.add(candidates.get(0));
            return;
        }
        LinkedHashMap<ManifestEntry.Identifier, ManifestEntry> map = new LinkedHashMap<ManifestEntry.Identifier, ManifestEntry>();
        for (ManifestFileMeta manifest : candidates) {
            ManifestEntry.mergeEntries(manifestFile.read(manifest.fileName), map);
        }
        if (!map.isEmpty()) {
            List<ManifestFileMeta> merged = manifestFile.write(new ArrayList<ManifestEntry>(map.values()));
            result.addAll(merged);
            newMetas.addAll(merged);
        }
    }
}

